/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.mediastorage;

import com.aventstack.extentreports.mediastorage.MediaStorage;
import com.aventstack.extentreports.mediastorage.impl.HttpMediaManagerImplKlov;
import com.aventstack.extentreports.mediastorage.model.KlovMedia;
import com.aventstack.extentreports.model.BasicMongoReportElement;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.utils.MongoUtil;
import java.io.IOException;
import org.bson.Document;
import org.bson.types.ObjectId;

public class KlovMediaStorageHandler {
    private MediaStorage mediaStorage;
    private KlovMedia klovMedia;

    public KlovMediaStorageHandler(String url, KlovMedia klovMedia) throws IOException {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("Invalid URL or resource not found");
        }
        this.klovMedia = klovMedia;
        this.mediaStorage = new HttpMediaManagerImplKlov();
        this.mediaStorage.init(url);
    }

    public void saveScreenCapture(BasicMongoReportElement el, ScreenCapture media) throws IOException {
        Document doc = new Document("project", (Object)this.klovMedia.getProjectId()).append("report", (Object)this.klovMedia.getReportId()).append("sequence", (Object)media.getSequence()).append("mediaType", (Object)media.getMediaType().toString().toLowerCase()).append("test", (Object)media.getTestObjectId());
        if (el.getClass() != Test.class) {
            doc.append("log", (Object)el.getObjectId());
        } else {
            doc.append("testName", (Object)((Test)el).getName());
        }
        this.klovMedia.getMediaCollection().insertOne((Object)doc);
        ObjectId mediaId = MongoUtil.getId(doc);
        media.setObjectId(mediaId);
        media.setReportObjectId(this.klovMedia.getReportId());
        this.mediaStorage.storeMedia(media);
    }
}

