/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;

public class FileUtil {
    private FileUtil() {
    }

    public static String getFileName(File f) {
        if (f == null || !f.exists()) {
            return "";
        }
        return f.getName();
    }

    public static String getFileName(String path) {
        return FileUtil.getFileName(new File(path));
    }

    public static String getFileNameWithoutExtension(File f) {
        String name = f.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            return name.substring(0, i);
        }
        return name;
    }

    public static String getFileNameWithoutExtension(String filePath) {
        return FileUtil.getFileNameWithoutExtension(new File(filePath));
    }

    public static String getExtension(File f) {
        String name = f.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            return name.substring(i + 1);
        }
        return "";
    }

    public static String getExtension(String filePath) {
        return FileUtil.getExtension(new File(filePath));
    }

    public static Boolean isDirectory(String filePath) {
        return FileUtil.isDirectory(new File(filePath));
    }

    public static Boolean isDirectory(File file) {
        Path path = file.toPath();
        return Files.isDirectory(path, new LinkOption[0]);
    }

    public static void createDirectory(String path) {
        new File(path).mkdirs();
    }

    public static void createDirectory(String[] path) {
        Arrays.asList(path).forEach(FileUtil::createDirectory);
    }

    public static Boolean fileExists(String path) {
        File f = new File(path);
        return f.exists() && !f.isDirectory();
    }

    public static long getFileSize(String path) {
        if (path == null) {
            return 0L;
        }
        File f = new File(path);
        return f.exists() ? f.length() : 0L;
    }
}

