/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.AnalysisStrategy;
import com.aventstack.extentreports.ReportAggregates;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.reporter.ConfigurableReporter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public abstract class AbstractReporter
extends ConfigurableReporter {
    protected List<Status> levels;
    protected Date startTime;
    protected Date endTime;
    protected List<Status> statusList;
    private AnalysisStrategy strategy;

    public AbstractReporter() {
        this.endTime = this.startTime = Calendar.getInstance().getTime();
        this.strategy = AnalysisStrategy.TEST;
    }

    @Override
    public void flush(ReportAggregates reportAggregates) {
        this.startTime = reportAggregates.getStartTime();
        this.endTime = reportAggregates.getEndTime();
        this.statusList = reportAggregates.getStatusList();
    }

    protected Date getStartTime() {
        return this.startTime;
    }

    protected void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    protected Date getEndTime() {
        return this.endTime;
    }

    @Override
    public void setAnalysisStrategy(AnalysisStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public AnalysisStrategy getAnalysisStrategy() {
        return this.strategy;
    }

    public long getRunDuration() {
        return this.endTime.getTime() - this.startTime.getTime();
    }

    public String getLongRunDuration() {
        long millis = this.getRunDuration();
        long secs = millis / 1000L;
        long ms = millis % 1000L;
        long mins = secs / 60L;
        long hours = mins / 60L;
        return hours + "h " + (mins %= 60L) + "m " + (secs %= 60L) + "s+" + ms + "ms";
    }

    public List<Status> getStatusList() {
        return this.statusList;
    }
}

