/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.GherkinKeyword;
import com.aventstack.extentreports.MediaEntityModelProvider;
import com.aventstack.extentreports.RunResult;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.gherkin.model.IGherkinFormatterModel;
import com.aventstack.extentreports.markuputils.Markup;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Device;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.IAddsMedia;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.MediaType;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Screencast;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.utils.StringUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public class ExtentTest
implements IAddsMedia<ExtentTest>,
RunResult,
Serializable {
    private static final long serialVersionUID = 9199820968410788862L;
    private transient ExtentReports extent;
    private Test test;

    ExtentTest(ExtentReports extent, Class<? extends IGherkinFormatterModel> type, String testName, String description) {
        if (testName == null || testName.isEmpty()) {
            throw new IllegalArgumentException("testName cannot be null or empty");
        }
        this.extent = extent;
        this.test = new Test();
        this.test.setName(testName.trim());
        this.test.setDescription(description == null ? "" : description.trim());
        if (type != null) {
            this.test.setBehaviorDrivenType(type);
        }
    }

    ExtentTest(ExtentReports extent, String testName, String description) {
        this(extent, null, testName, description);
    }

    public synchronized ExtentTest createNode(Class<? extends IGherkinFormatterModel> type, String name, String description) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("nodeName cannot be null or empty");
        }
        ExtentTest t = type == null ? new ExtentTest(this.extent, name, description) : new ExtentTest(this.extent, type, name, description);
        this.applyCommonNodeSettings(t);
        this.addNodeToReport(t);
        return t;
    }

    public synchronized ExtentTest createNode(String name, String description) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("nodeName cannot be null or empty");
        }
        ExtentTest t = new ExtentTest(this.extent, name, description);
        this.applyCommonNodeSettings(t);
        this.addNodeToReport(t);
        return t;
    }

    public synchronized ExtentTest createNode(Class<? extends IGherkinFormatterModel> type, String name) {
        return this.createNode(type, name, null);
    }

    public synchronized ExtentTest createNode(GherkinKeyword gherkinKeyword, String name, String description) {
        Class<?> clazz = gherkinKeyword.getKeyword().getClass();
        return this.createNode(clazz, name, description);
    }

    public synchronized ExtentTest createNode(GherkinKeyword gherkinKeyword, String name) {
        return this.createNode(gherkinKeyword, name, null);
    }

    public synchronized ExtentTest createNode(String name) {
        return this.createNode(name, null);
    }

    private void applyCommonNodeSettings(ExtentTest extentTest) {
        extentTest.getModel().setLevel(this.test.getLevel() + 1);
        extentTest.getModel().setParent(this.getModel());
        this.test.getNodeContext().add(extentTest.getModel());
    }

    private void addNodeToReport(ExtentTest extentNode) {
        this.extent.addNode(extentNode.getModel());
    }

    public synchronized ExtentTest log(Status status, String details, MediaEntityModelProvider provider) {
        Log evt = this.createLog(status, details);
        this.addMedia(evt, provider);
        return this.addLog(evt);
    }

    private synchronized void addMedia(Log evt, MediaEntityModelProvider provider) {
        if (provider != null) {
            Class<?> clazz = provider.getMedia().getClass();
            if (clazz.equals(ScreenCapture.class)) {
                ScreenCapture sc = (ScreenCapture)provider.getMedia();
                evt.setScreenCapture(sc);
            } else {
                evt.setScreencast((Screencast)provider.getMedia());
            }
        }
    }

    public synchronized ExtentTest log(Status status, String details) {
        return this.log(status, details, null);
    }

    public synchronized ExtentTest log(Status status, Markup markup) {
        String details = markup.getMarkup();
        return this.log(status, details);
    }

    private synchronized ExtentTest addLog(Log evt) {
        this.test.getLogContext().add(evt);
        this.test.end();
        this.extent.addLog(this.test, evt);
        if (evt.hasScreenCapture()) {
            try {
                this.extent.addScreenCapture(evt, evt.getScreenCaptureContext().getLast());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    private Log createLog(Status status) {
        Log evt = new Log(this);
        evt.setStatus(status);
        evt.setSequence(this.test.getLogContext().getAll().size() + 1);
        return evt;
    }

    private Log createLog(Status status, String details) {
        Log evt = this.createLog(status);
        evt.setDetails(details == null ? "" : details.trim());
        return evt;
    }

    public synchronized ExtentTest log(Status status, Throwable t, MediaEntityModelProvider provider) {
        ExceptionInfo exInfo = new ExceptionInfo(t);
        this.getModel().setExceptionInfo(exInfo);
        Log evt = this.createLog(status);
        evt.setExceptionInfo(exInfo);
        this.addMedia(evt, provider);
        return this.addLog(evt);
    }

    public synchronized ExtentTest log(Status status, Throwable t) {
        return this.log(status, t, null);
    }

    public ExtentTest info(String details, MediaEntityModelProvider provider) {
        this.log(Status.INFO, details, provider);
        return this;
    }

    public ExtentTest info(String details) {
        return this.info(details, null);
    }

    public ExtentTest info(Throwable t, MediaEntityModelProvider provider) {
        this.log(Status.INFO, t, provider);
        return this;
    }

    public ExtentTest info(Throwable t) {
        return this.info(t, null);
    }

    public ExtentTest info(Markup m) {
        this.log(Status.INFO, m);
        return this;
    }

    public ExtentTest pass(String details, MediaEntityModelProvider provider) {
        this.log(Status.PASS, details, provider);
        return this;
    }

    public ExtentTest pass(String details) {
        return this.pass(details, null);
    }

    public ExtentTest pass(Throwable t, MediaEntityModelProvider provider) {
        this.log(Status.PASS, t, provider);
        return this;
    }

    public ExtentTest pass(Throwable t) {
        return this.pass(t, null);
    }

    public ExtentTest pass(Markup m) {
        this.log(Status.PASS, m);
        return this;
    }

    public ExtentTest fail(String details, MediaEntityModelProvider provider) {
        this.log(Status.FAIL, details, provider);
        return this;
    }

    public ExtentTest fail(String details) {
        return this.fail(details, null);
    }

    public ExtentTest fail(Throwable t, MediaEntityModelProvider provider) {
        this.log(Status.FAIL, t, provider);
        return this;
    }

    public ExtentTest fail(Throwable t) {
        return this.fail(t, null);
    }

    public ExtentTest fail(Markup m) {
        this.log(Status.FAIL, m);
        return this;
    }

    public ExtentTest fatal(String details, MediaEntityModelProvider provider) {
        this.log(Status.FATAL, details, provider);
        return this;
    }

    public ExtentTest fatal(String details) {
        this.log(Status.FATAL, details);
        return this;
    }

    public ExtentTest fatal(Throwable t, MediaEntityModelProvider provider) {
        this.log(Status.FATAL, t, provider);
        return this;
    }

    public ExtentTest fatal(Throwable t) {
        this.log(Status.FATAL, t);
        return this;
    }

    public ExtentTest fatal(Markup m) {
        this.log(Status.FATAL, m);
        return this;
    }

    public ExtentTest warning(String details, MediaEntityModelProvider provider) {
        this.log(Status.WARNING, details, provider);
        return this;
    }

    public ExtentTest warning(String details) {
        return this.warning(details, null);
    }

    public ExtentTest warning(Throwable t, MediaEntityModelProvider provider) {
        this.log(Status.WARNING, t, provider);
        return this;
    }

    public ExtentTest warning(Throwable t) {
        return this.warning(t, null);
    }

    public ExtentTest warning(Markup m) {
        this.log(Status.WARNING, m);
        return this;
    }

    public ExtentTest error(String details, MediaEntityModelProvider provider) {
        this.log(Status.ERROR, details, provider);
        return this;
    }

    public ExtentTest error(String details) {
        return this.error(details, null);
    }

    public ExtentTest error(Throwable t, MediaEntityModelProvider provider) {
        this.log(Status.ERROR, t, provider);
        return this;
    }

    public ExtentTest error(Throwable t) {
        return this.error(t, null);
    }

    public ExtentTest error(Markup m) {
        this.log(Status.ERROR, m);
        return this;
    }

    public ExtentTest skip(String details, MediaEntityModelProvider provider) {
        this.log(Status.SKIP, details, provider);
        return this;
    }

    public ExtentTest skip(String details) {
        return this.skip(details, null);
    }

    public ExtentTest skip(Throwable t, MediaEntityModelProvider provider) {
        this.log(Status.SKIP, t, provider);
        return this;
    }

    public ExtentTest skip(Throwable t) {
        return this.skip(t, null);
    }

    public ExtentTest skip(Markup m) {
        this.log(Status.SKIP, m);
        return this;
    }

    public ExtentTest debug(String details, MediaEntityModelProvider provider) {
        this.log(Status.DEBUG, details, provider);
        return this;
    }

    public ExtentTest debug(String details) {
        return this.debug(details, null);
    }

    public ExtentTest debug(Throwable t, MediaEntityModelProvider provider) {
        this.log(Status.DEBUG, t, provider);
        return this;
    }

    public ExtentTest debug(Throwable t) {
        return this.debug(t, null);
    }

    public ExtentTest debug(Markup m) {
        this.log(Status.DEBUG, m);
        return this;
    }

    public ExtentTest assignCategory(String ... category) {
        if (category == null) {
            return this;
        }
        Arrays.stream(category).filter(StringUtil::isNotNullOrEmpty).forEach(c -> {
            Category objCategory = new Category(c.replace(" ", ""));
            this.test.setCategory(objCategory);
            this.extent.assignCategory(this.test, objCategory);
        });
        return this;
    }

    public ExtentTest assignAuthor(String ... author) {
        Arrays.stream(author).filter(StringUtil::isNotNullOrEmpty).forEach(x -> {
            Author a = new Author(x.replace(" ", ""));
            this.test.setAuthor(a);
            this.extent.assignAuthor(this.test, a);
        });
        return this;
    }

    public ExtentTest assignDevice(String ... device) {
        Arrays.stream(device).filter(StringUtil::isNotNullOrEmpty).forEach(x -> {
            Device d = new Device(x.replace(" ", ""));
            this.test.setDevice(d);
            this.extent.assignDevice(this.test, d);
        });
        return this;
    }

    @Override
    public ExtentTest addScreenCaptureFromPath(String imagePath, String title) throws IOException {
        if (imagePath == null || imagePath.isEmpty()) {
            throw new IllegalArgumentException("imagePath cannot be null or empty");
        }
        ScreenCapture screenCapture = new ScreenCapture();
        screenCapture.setPath(imagePath);
        if (title != null) {
            screenCapture.setName(title);
        }
        screenCapture.setMediaType(MediaType.IMG);
        if (this.test.getObjectId() != null) {
            screenCapture.setTestObjectId(this.test.getObjectId());
        }
        this.extent.addScreenCapture(this.test, screenCapture);
        return this.addScreenCapture(screenCapture);
    }

    private ExtentTest addScreenCapture(ScreenCapture screenCapture) {
        this.test.setScreenCapture(screenCapture);
        if (this.test.getObjectId() != null) {
            int sequence = this.test.getScreenCaptureList().size();
            screenCapture.setTestObjectId(this.test.getObjectId());
            screenCapture.setSequence(sequence);
        }
        return this;
    }

    @Override
    public ExtentTest addScreenCaptureFromPath(String imagePath) throws IOException {
        return this.addScreenCaptureFromPath(imagePath, null);
    }

    @Override
    public ExtentTest addScreenCaptureFromBase64String(String s, String title) {
        ScreenCapture screenCapture = new ScreenCapture();
        screenCapture.setBase64String(s);
        screenCapture.setName(title);
        screenCapture.setMediaType(MediaType.IMG);
        if (this.test.getObjectId() != null) {
            screenCapture.setTestObjectId(this.test.getObjectId());
        }
        try {
            this.extent.addScreenCapture(this.test, screenCapture);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.addScreenCapture(screenCapture);
    }

    @Override
    public ExtentTest addScreenCaptureFromBase64String(String s) {
        return this.addScreenCaptureFromBase64String(s, null);
    }

    @Override
    public ExtentTest addScreencastFromPath(String screencastPath) throws IOException {
        Screencast screencast = new Screencast();
        screencast.setPath(screencastPath);
        screencast.setMediaType(MediaType.VID);
        this.test.setScreencast(screencast);
        if (this.test.getObjectId() != null) {
            int sequence = this.test.getScreencastList().size();
            screencast.setTestObjectId(this.test.getObjectId());
            screencast.setSequence(sequence);
        }
        this.extent.addScreencast(this.test, screencast);
        return this;
    }

    @Override
    public Status getStatus() {
        return this.getModel().getStatus();
    }

    public Test getModel() {
        return this.test;
    }

    public ExtentReports getExtent() {
        return this.extent;
    }

    void setUseManualConfiguration(Boolean b) {
        this.getModel().setUseManualConfiguration(b);
    }
}

