/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.mediastorage.impl;

import com.aventstack.extentreports.mediastorage.MediaStorage;
import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.utils.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class HttpMediaManagerImplKlov
implements MediaStorage {
    private static final Logger logger = Logger.getLogger(HttpMediaManagerImplKlov.class.getName());
    private static final String ROUTE = "files/upload";
    private String host;

    @Override
    public void init(String host) throws IOException {
        this.host = host;
        if (host.lastIndexOf(47) != host.length() - 1) {
            this.host = String.valueOf(host) + "/";
        }
    }

    @Override
    public void storeMedia(Media m) throws IOException {
        if (m.getPath() == null || m.getBase64String() != null) {
            return;
        }
        File f = new File(m.getPath());
        if (!f.exists()) {
            throw new IOException("The system cannot find the file specified " + m.getPath());
        }
        HttpPost post = new HttpPost(String.valueOf(this.host) + ROUTE);
        post.addHeader("Connection", "keep-alive");
        post.addHeader("User-Agent", "Mozilla/5.0");
        post.addHeader("Accept", "application/json");
        String ext = FileUtil.getExtension(m.getPath());
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("name", (ContentBody)new StringBody(String.valueOf(m.getSequence()) + "." + ext, ContentType.TEXT_PLAIN));
        builder.addPart("id", (ContentBody)new StringBody(m.getObjectId().toString(), ContentType.TEXT_PLAIN));
        builder.addPart("reportId", (ContentBody)new StringBody(m.getReportObjectId().toString(), ContentType.TEXT_PLAIN));
        builder.addPart("testId", (ContentBody)new StringBody(m.getTestObjectId().toString(), ContentType.TEXT_PLAIN));
        builder.addPart("mediaType", (ContentBody)new StringBody(String.valueOf((Object)m.getMediaType()).toLowerCase(), ContentType.TEXT_PLAIN));
        builder.addPart("f", (ContentBody)new FileBody(new File(m.getPath())));
        post.setEntity(builder.build());
        String logId = m.getLogObjectId() == null ? "" : m.getLogObjectId().toString();
        builder.addPart("logId", (ContentBody)new StringBody(logId, ContentType.TEXT_PLAIN));
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpResponse response = client.execute((HttpUriRequest)post);
        int responseCode = response.getStatusLine().getStatusCode();
        boolean isValid = this.isResponseValid(responseCode);
        if (!isValid) {
            logger.warning("Unable to upload file to server " + m.getPath());
        }
    }

    private boolean isResponseValid(int responseCode) {
        return 200 <= responseCode && responseCode <= 399;
    }
}

