/*
 * Decompiled with CFR 0.152.
 */
package com.avast.android.dialogs.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.text.Html;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.TextUtils;
import android.view.View;
import com.avast.android.dialogs.core.BaseDialogBuilder;
import com.avast.android.dialogs.core.BaseDialogFragment;
import com.avast.android.dialogs.iface.INegativeButtonDialogListener;
import com.avast.android.dialogs.iface.INeutralButtonDialogListener;
import com.avast.android.dialogs.iface.IPositiveButtonDialogListener;
import java.util.List;

public class SimpleDialogFragment
extends BaseDialogFragment {
    protected static final String ARG_MESSAGE = "message";
    protected static final String ARG_TITLE = "title";
    protected static final String ARG_POSITIVE_BUTTON = "positive_button";
    protected static final String ARG_NEGATIVE_BUTTON = "negative_button";
    protected static final String ARG_NEUTRAL_BUTTON = "neutral_button";

    public static SimpleDialogBuilder createBuilder(Context context, FragmentManager fragmentManager) {
        return new SimpleDialogBuilder(context, fragmentManager, (Class<? extends SimpleDialogFragment>)SimpleDialogFragment.class);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    @Override
    protected BaseDialogFragment.Builder build(BaseDialogFragment.Builder builder) {
        CharSequence neutralButtonText;
        CharSequence negativeButtonText;
        CharSequence positiveButtonText;
        CharSequence message;
        CharSequence title = this.getTitle();
        if (!TextUtils.isEmpty((CharSequence)title)) {
            builder.setTitle(title);
        }
        if (!TextUtils.isEmpty((CharSequence)(message = this.getMessage()))) {
            builder.setMessage(message);
        }
        if (!TextUtils.isEmpty((CharSequence)(positiveButtonText = this.getPositiveButtonText()))) {
            builder.setPositiveButton(positiveButtonText, new View.OnClickListener(){

                public void onClick(View view) {
                    for (IPositiveButtonDialogListener listener : SimpleDialogFragment.this.getPositiveButtonDialogListeners()) {
                        listener.onPositiveButtonClicked(SimpleDialogFragment.this.mRequestCode);
                    }
                    SimpleDialogFragment.this.dismiss();
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)(negativeButtonText = this.getNegativeButtonText()))) {
            builder.setNegativeButton(negativeButtonText, new View.OnClickListener(){

                public void onClick(View view) {
                    for (INegativeButtonDialogListener listener : SimpleDialogFragment.this.getNegativeButtonDialogListeners()) {
                        listener.onNegativeButtonClicked(SimpleDialogFragment.this.mRequestCode);
                    }
                    SimpleDialogFragment.this.dismiss();
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)(neutralButtonText = this.getNeutralButtonText()))) {
            builder.setNeutralButton(neutralButtonText, new View.OnClickListener(){

                public void onClick(View view) {
                    for (INeutralButtonDialogListener listener : SimpleDialogFragment.this.getNeutralButtonDialogListeners()) {
                        listener.onNeutralButtonClicked(SimpleDialogFragment.this.mRequestCode);
                    }
                    SimpleDialogFragment.this.dismiss();
                }
            });
        }
        return builder;
    }

    protected CharSequence getMessage() {
        return this.getArguments().getCharSequence(ARG_MESSAGE);
    }

    protected CharSequence getTitle() {
        return this.getArguments().getCharSequence(ARG_TITLE);
    }

    protected CharSequence getPositiveButtonText() {
        return this.getArguments().getCharSequence(ARG_POSITIVE_BUTTON);
    }

    protected CharSequence getNegativeButtonText() {
        return this.getArguments().getCharSequence(ARG_NEGATIVE_BUTTON);
    }

    protected CharSequence getNeutralButtonText() {
        return this.getArguments().getCharSequence(ARG_NEUTRAL_BUTTON);
    }

    protected List<IPositiveButtonDialogListener> getPositiveButtonDialogListeners() {
        return this.getDialogListeners(IPositiveButtonDialogListener.class);
    }

    protected List<INegativeButtonDialogListener> getNegativeButtonDialogListeners() {
        return this.getDialogListeners(INegativeButtonDialogListener.class);
    }

    protected List<INeutralButtonDialogListener> getNeutralButtonDialogListeners() {
        return this.getDialogListeners(INeutralButtonDialogListener.class);
    }

    public static class SimpleDialogBuilder
    extends BaseDialogBuilder<SimpleDialogBuilder> {
        private CharSequence mTitle;
        private CharSequence mMessage;
        private CharSequence mPositiveButtonText;
        private CharSequence mNegativeButtonText;
        private CharSequence mNeutralButtonText;

        protected SimpleDialogBuilder(Context context, FragmentManager fragmentManager, Class<? extends SimpleDialogFragment> clazz) {
            super(context, fragmentManager, clazz);
        }

        @Override
        protected SimpleDialogBuilder self() {
            return this;
        }

        public SimpleDialogBuilder setTitle(int titleResourceId) {
            this.mTitle = this.mContext.getString(titleResourceId);
            return this;
        }

        public SimpleDialogBuilder setTitle(CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public SimpleDialogBuilder setMessage(int messageResourceId) {
            this.mMessage = this.mContext.getText(messageResourceId);
            return this;
        }

        public SimpleDialogBuilder setMessage(int resourceId, Object ... formatArgs) {
            this.mMessage = Html.fromHtml((String)String.format(Html.toHtml((Spanned)new SpannedString(this.mContext.getText(resourceId))), formatArgs));
            return this;
        }

        public SimpleDialogBuilder setMessage(CharSequence message) {
            this.mMessage = message;
            return this;
        }

        public SimpleDialogBuilder setPositiveButtonText(int textResourceId) {
            this.mPositiveButtonText = this.mContext.getString(textResourceId);
            return this;
        }

        public SimpleDialogBuilder setPositiveButtonText(CharSequence text) {
            this.mPositiveButtonText = text;
            return this;
        }

        public SimpleDialogBuilder setNegativeButtonText(int textResourceId) {
            this.mNegativeButtonText = this.mContext.getString(textResourceId);
            return this;
        }

        public SimpleDialogBuilder setNegativeButtonText(CharSequence text) {
            this.mNegativeButtonText = text;
            return this;
        }

        public SimpleDialogBuilder setNeutralButtonText(int textResourceId) {
            this.mNeutralButtonText = this.mContext.getString(textResourceId);
            return this;
        }

        public SimpleDialogBuilder setNeutralButtonText(CharSequence text) {
            this.mNeutralButtonText = text;
            return this;
        }

        @Override
        protected Bundle prepareArguments() {
            Bundle args = new Bundle();
            args.putCharSequence(SimpleDialogFragment.ARG_MESSAGE, this.mMessage);
            args.putCharSequence(SimpleDialogFragment.ARG_TITLE, this.mTitle);
            args.putCharSequence(SimpleDialogFragment.ARG_POSITIVE_BUTTON, this.mPositiveButtonText);
            args.putCharSequence(SimpleDialogFragment.ARG_NEGATIVE_BUTTON, this.mNegativeButtonText);
            args.putCharSequence(SimpleDialogFragment.ARG_NEUTRAL_BUTTON, this.mNeutralButtonText);
            return args;
        }
    }
}

