/*
 * Decompiled with CFR 0.152.
 */
package com.avast.android.dialogs.fragment;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.IntDef;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.SparseBooleanArray;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.avast.android.dialogs.R;
import com.avast.android.dialogs.core.BaseDialogBuilder;
import com.avast.android.dialogs.core.BaseDialogFragment;
import com.avast.android.dialogs.iface.IListDialogListener;
import com.avast.android.dialogs.iface.IMultiChoiceListDialogListener;
import com.avast.android.dialogs.iface.ISimpleDialogCancelListener;
import com.avast.android.dialogs.util.SparseBooleanArrayParcelable;
import java.util.Arrays;
import java.util.List;

public class ListDialogFragment
extends BaseDialogFragment {
    protected static final String ARG_ITEMS = "items";
    protected static final String ARG_CHECKED_ITEMS = "checkedItems";
    protected static final String ARG_MODE = "choiceMode";
    protected static final String ARG_TITLE = "title";
    protected static final String ARG_POSITIVE_BUTTON = "positive_button";
    protected static final String ARG_NEGATIVE_BUTTON = "negative_button";

    public static SimpleListDialogBuilder createBuilder(Context context, FragmentManager fragmentManager) {
        return new SimpleListDialogBuilder(context, fragmentManager);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (this.getArguments() == null) {
            throw new IllegalArgumentException("use SimpleListDialogBuilder to construct this dialog");
        }
    }

    private ListAdapter prepareAdapter(int itemLayoutId) {
        return new ArrayAdapter((Context)this.getActivity(), itemLayoutId, R.id.sdl_text, (Object[])this.getItems());
    }

    private void buildMultiChoice(BaseDialogFragment.Builder builder) {
        builder.setItems(this.prepareAdapter(R.layout.sdl_list_item_multichoice), ListDialogFragment.asIntArray(this.getCheckedItems()), 2, new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                SparseBooleanArray checkedPositions = ((ListView)parent).getCheckedItemPositions();
                ListDialogFragment.this.setCheckedItems(new SparseBooleanArrayParcelable(checkedPositions));
            }
        });
    }

    private void buildSingleChoice(BaseDialogFragment.Builder builder) {
        builder.setItems(this.prepareAdapter(R.layout.sdl_list_item_singlechoice), ListDialogFragment.asIntArray(this.getCheckedItems()), 1, new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                SparseBooleanArray checkedPositions = ((ListView)parent).getCheckedItemPositions();
                ListDialogFragment.this.setCheckedItems(new SparseBooleanArrayParcelable(checkedPositions));
            }
        });
    }

    private void buildNormalChoice(BaseDialogFragment.Builder builder) {
        builder.setItems(this.prepareAdapter(R.layout.sdl_list_item), -1, new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                for (IListDialogListener listener : ListDialogFragment.this.getSingleDialogListeners()) {
                    listener.onListItemSelected(ListDialogFragment.this.getItems()[position], position, ListDialogFragment.this.mRequestCode);
                }
                ListDialogFragment.this.dismiss();
            }
        });
    }

    @Override
    protected BaseDialogFragment.Builder build(BaseDialogFragment.Builder builder) {
        String[] items;
        String title = this.getTitle();
        if (!TextUtils.isEmpty((CharSequence)title)) {
            builder.setTitle(title);
        }
        if (!TextUtils.isEmpty((CharSequence)this.getNegativeButtonText())) {
            builder.setNegativeButton(this.getNegativeButtonText(), new View.OnClickListener(){

                public void onClick(View view) {
                    for (ISimpleDialogCancelListener listener : ListDialogFragment.this.getCancelListeners()) {
                        listener.onCancelled(ListDialogFragment.this.mRequestCode);
                    }
                    ListDialogFragment.this.dismiss();
                }
            });
        }
        if (this.getMode() != 0) {
            Object positiveButtonClickListener = null;
            switch (this.getMode()) {
                case 2: {
                    positiveButtonClickListener = new View.OnClickListener(){

                        public void onClick(View view) {
                            int[] checkedPositions = ListDialogFragment.asIntArray(ListDialogFragment.this.getCheckedItems());
                            String[] items = ListDialogFragment.this.getItems();
                            String[] checkedValues = new String[checkedPositions.length];
                            int i = 0;
                            for (int checkedPosition : checkedPositions) {
                                if (checkedPosition < 0 || checkedPosition >= items.length) continue;
                                checkedValues[i++] = items[checkedPosition];
                            }
                            Object object = ListDialogFragment.this.getMutlipleDialogListeners().iterator();
                            while (object.hasNext()) {
                                IMultiChoiceListDialogListener listener = (IMultiChoiceListDialogListener)object.next();
                                listener.onListItemsSelected(checkedValues, checkedPositions, ListDialogFragment.this.mRequestCode);
                            }
                            ListDialogFragment.this.dismiss();
                        }
                    };
                    break;
                }
                case 1: {
                    positiveButtonClickListener = new View.OnClickListener(){

                        public void onClick(View view) {
                            Object object;
                            int selectedPosition = -1;
                            int[] checkedPositions = ListDialogFragment.asIntArray(ListDialogFragment.this.getCheckedItems());
                            String[] items = ListDialogFragment.this.getItems();
                            for (int i : checkedPositions) {
                                if (i < 0 || i >= items.length) continue;
                                selectedPosition = i;
                                break;
                            }
                            if (selectedPosition != -1) {
                                object = ListDialogFragment.this.getSingleDialogListeners().iterator();
                                while (object.hasNext()) {
                                    IListDialogListener listener = (IListDialogListener)object.next();
                                    listener.onListItemSelected(items[selectedPosition], selectedPosition, ListDialogFragment.this.mRequestCode);
                                }
                            } else {
                                object = ListDialogFragment.this.getCancelListeners().iterator();
                                while (object.hasNext()) {
                                    ISimpleDialogCancelListener listener = (ISimpleDialogCancelListener)object.next();
                                    listener.onCancelled(ListDialogFragment.this.mRequestCode);
                                }
                            }
                            ListDialogFragment.this.dismiss();
                        }
                    };
                }
            }
            String positiveButton = this.getPositiveButtonText();
            if (TextUtils.isEmpty((CharSequence)this.getPositiveButtonText())) {
                positiveButton = this.getString(17039370);
            }
            builder.setPositiveButton(positiveButton, (View.OnClickListener)positiveButtonClickListener);
        }
        if ((items = this.getItems()) != null && items.length > 0) {
            int mode = this.getMode();
            switch (mode) {
                case 2: {
                    this.buildMultiChoice(builder);
                    break;
                }
                case 1: {
                    this.buildSingleChoice(builder);
                    break;
                }
                case 0: {
                    this.buildNormalChoice(builder);
                }
            }
        }
        return builder;
    }

    private List<IListDialogListener> getSingleDialogListeners() {
        return this.getDialogListeners(IListDialogListener.class);
    }

    private List<IMultiChoiceListDialogListener> getMutlipleDialogListeners() {
        return this.getDialogListeners(IMultiChoiceListDialogListener.class);
    }

    private String getTitle() {
        return this.getArguments().getString(ARG_TITLE);
    }

    @ChoiceMode
    private int getMode() {
        return this.getArguments().getInt(ARG_MODE);
    }

    private String[] getItems() {
        return this.getArguments().getStringArray(ARG_ITEMS);
    }

    private void setCheckedItems(SparseBooleanArrayParcelable checkedItems) {
        this.getArguments().putParcelable(ARG_CHECKED_ITEMS, (Parcelable)checkedItems);
    }

    @NonNull
    private SparseBooleanArrayParcelable getCheckedItems() {
        SparseBooleanArrayParcelable items = (SparseBooleanArrayParcelable)this.getArguments().getParcelable(ARG_CHECKED_ITEMS);
        if (items == null) {
            items = new SparseBooleanArrayParcelable();
        }
        return items;
    }

    private String getPositiveButtonText() {
        return this.getArguments().getString(ARG_POSITIVE_BUTTON);
    }

    private String getNegativeButtonText() {
        return this.getArguments().getString(ARG_NEGATIVE_BUTTON);
    }

    private static int[] asIntArray(SparseBooleanArray checkedItems) {
        int checked = 0;
        for (int i = 0; i < checkedItems.size(); ++i) {
            int key = checkedItems.keyAt(i);
            if (!checkedItems.get(key)) continue;
            ++checked;
        }
        int[] array = new int[checked];
        int j = 0;
        for (int i = 0; i < checkedItems.size(); ++i) {
            int key = checkedItems.keyAt(i);
            if (!checkedItems.get(key)) continue;
            array[j++] = key;
        }
        Arrays.sort(array);
        return array;
    }

    public static class SimpleListDialogBuilder
    extends BaseDialogBuilder<SimpleListDialogBuilder> {
        private String title;
        private String[] items;
        @ChoiceMode
        private int mode;
        private int[] checkedItems;
        private String cancelButtonText;
        private String confirmButtonText;

        public SimpleListDialogBuilder(Context context, FragmentManager fragmentManager) {
            super(context, fragmentManager, ListDialogFragment.class);
        }

        @Override
        protected SimpleListDialogBuilder self() {
            return this;
        }

        private Resources getResources() {
            return this.mContext.getResources();
        }

        public SimpleListDialogBuilder setTitle(String title) {
            this.title = title;
            return this;
        }

        public SimpleListDialogBuilder setTitle(int titleResID) {
            this.title = this.getResources().getString(titleResID);
            return this;
        }

        public SimpleListDialogBuilder setCheckedItems(int[] positions) {
            this.checkedItems = positions;
            return this;
        }

        public SimpleListDialogBuilder setSelectedItem(int position) {
            this.checkedItems = new int[]{position};
            return this;
        }

        public SimpleListDialogBuilder setChoiceMode(@ChoiceMode int choiceMode) {
            this.mode = choiceMode;
            return this;
        }

        public SimpleListDialogBuilder setItems(String[] items) {
            this.items = items;
            return this;
        }

        public SimpleListDialogBuilder setItems(int itemsArrayResID) {
            this.items = this.getResources().getStringArray(itemsArrayResID);
            return this;
        }

        public SimpleListDialogBuilder setConfirmButtonText(String text) {
            this.confirmButtonText = text;
            return this;
        }

        public SimpleListDialogBuilder setConfirmButtonText(int confirmBttTextResID) {
            this.confirmButtonText = this.getResources().getString(confirmBttTextResID);
            return this;
        }

        public SimpleListDialogBuilder setCancelButtonText(String text) {
            this.cancelButtonText = text;
            return this;
        }

        public SimpleListDialogBuilder setCancelButtonText(int cancelBttTextResID) {
            this.cancelButtonText = this.getResources().getString(cancelBttTextResID);
            return this;
        }

        @Override
        public ListDialogFragment show() {
            return (ListDialogFragment)super.show();
        }

        @Override
        protected Bundle prepareArguments() {
            Bundle args = new Bundle();
            args.putString(ListDialogFragment.ARG_TITLE, this.title);
            args.putString(ListDialogFragment.ARG_POSITIVE_BUTTON, this.confirmButtonText);
            args.putString(ListDialogFragment.ARG_NEGATIVE_BUTTON, this.cancelButtonText);
            args.putStringArray(ListDialogFragment.ARG_ITEMS, this.items);
            SparseBooleanArrayParcelable sparseArray = new SparseBooleanArrayParcelable();
            for (int index = 0; this.checkedItems != null && index < this.checkedItems.length; ++index) {
                sparseArray.put(this.checkedItems[index], true);
            }
            args.putParcelable(ListDialogFragment.ARG_CHECKED_ITEMS, (Parcelable)sparseArray);
            args.putInt(ListDialogFragment.ARG_MODE, this.mode);
            return args;
        }
    }

    @IntDef(value={2L, 1L, 0L})
    public static @interface ChoiceMode {
    }
}

