/*
 * Decompiled with CFR 0.152.
 */
package com.avast.android.dialogs.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.Html;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.TextUtils;
import android.view.View;
import com.avast.android.dialogs.core.BaseDialogBuilder;
import com.avast.android.dialogs.core.BaseDialogFragment;
import com.avast.android.dialogs.iface.ISimpleDialogCancelListener;
import com.avast.android.dialogs.iface.ISimpleDialogListener;

public class SimpleDialogFragment
extends BaseDialogFragment {
    protected static final String ARG_MESSAGE = "message";
    protected static final String ARG_TITLE = "title";
    protected static final String ARG_POSITIVE_BUTTON = "positive_button";
    protected static final String ARG_NEGATIVE_BUTTON = "negative_button";
    protected static final String ARG_NEUTRAL_BUTTON = "neutral_button";
    protected int mRequestCode;

    public static SimpleDialogBuilder createBuilder(Context context, FragmentManager fragmentManager) {
        return new SimpleDialogBuilder(context, fragmentManager, (Class<? extends SimpleDialogFragment>)SimpleDialogFragment.class);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Fragment targetFragment = this.getTargetFragment();
        if (targetFragment != null) {
            this.mRequestCode = this.getTargetRequestCode();
        } else {
            Bundle args = this.getArguments();
            if (args != null) {
                this.mRequestCode = args.getInt("request_code", 0);
            }
        }
    }

    @Override
    protected BaseDialogFragment.Builder build(BaseDialogFragment.Builder builder) {
        String neutralButtonText;
        String negativeButtonText;
        String positiveButtonText;
        CharSequence message;
        String title = this.getTitle();
        if (!TextUtils.isEmpty((CharSequence)title)) {
            builder.setTitle(title);
        }
        if (!TextUtils.isEmpty((CharSequence)(message = this.getMessage()))) {
            builder.setMessage(message);
        }
        if (!TextUtils.isEmpty((CharSequence)(positiveButtonText = this.getPositiveButtonText()))) {
            builder.setPositiveButton(positiveButtonText, new View.OnClickListener(){

                public void onClick(View view) {
                    ISimpleDialogListener listener = SimpleDialogFragment.this.getDialogListener();
                    if (listener != null) {
                        listener.onPositiveButtonClicked(SimpleDialogFragment.this.mRequestCode);
                    }
                    SimpleDialogFragment.this.dismiss();
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)(negativeButtonText = this.getNegativeButtonText()))) {
            builder.setNegativeButton(negativeButtonText, new View.OnClickListener(){

                public void onClick(View view) {
                    ISimpleDialogListener listener = SimpleDialogFragment.this.getDialogListener();
                    if (listener != null) {
                        listener.onNegativeButtonClicked(SimpleDialogFragment.this.mRequestCode);
                    }
                    SimpleDialogFragment.this.dismiss();
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)(neutralButtonText = this.getNeutralButtonText()))) {
            builder.setNeutralButton(neutralButtonText, new View.OnClickListener(){

                public void onClick(View view) {
                    ISimpleDialogListener listener = SimpleDialogFragment.this.getDialogListener();
                    if (listener != null) {
                        listener.onNeutralButtonClicked(SimpleDialogFragment.this.mRequestCode);
                    }
                    SimpleDialogFragment.this.dismiss();
                }
            });
        }
        return builder;
    }

    protected CharSequence getMessage() {
        return this.getArguments().getCharSequence(ARG_MESSAGE);
    }

    protected String getTitle() {
        return this.getArguments().getString(ARG_TITLE);
    }

    protected String getPositiveButtonText() {
        return this.getArguments().getString(ARG_POSITIVE_BUTTON);
    }

    protected String getNegativeButtonText() {
        return this.getArguments().getString(ARG_NEGATIVE_BUTTON);
    }

    protected String getNeutralButtonText() {
        return this.getArguments().getString(ARG_NEUTRAL_BUTTON);
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        ISimpleDialogCancelListener listener = this.getCancelListener();
        if (listener != null) {
            listener.onCancelled(this.mRequestCode);
        }
    }

    protected ISimpleDialogListener getDialogListener() {
        Fragment targetFragment = this.getTargetFragment();
        if (targetFragment != null) {
            if (targetFragment instanceof ISimpleDialogListener) {
                return (ISimpleDialogListener)targetFragment;
            }
        } else if (this.getActivity() instanceof ISimpleDialogListener) {
            return (ISimpleDialogListener)this.getActivity();
        }
        return null;
    }

    protected ISimpleDialogCancelListener getCancelListener() {
        Fragment targetFragment = this.getTargetFragment();
        if (targetFragment != null) {
            if (targetFragment instanceof ISimpleDialogCancelListener) {
                return (ISimpleDialogCancelListener)targetFragment;
            }
        } else if (this.getActivity() instanceof ISimpleDialogCancelListener) {
            return (ISimpleDialogCancelListener)this.getActivity();
        }
        return null;
    }

    public static class SimpleDialogBuilder
    extends BaseDialogBuilder<SimpleDialogBuilder> {
        private String mTitle;
        private CharSequence mMessage;
        private String mPositiveButtonText;
        private String mNegativeButtonText;
        private String mNeutralButtonText;

        protected SimpleDialogBuilder(Context context, FragmentManager fragmentManager, Class<? extends SimpleDialogFragment> clazz) {
            super(context, fragmentManager, clazz);
        }

        @Override
        protected SimpleDialogBuilder self() {
            return this;
        }

        public SimpleDialogBuilder setTitle(int titleResourceId) {
            this.mTitle = this.mContext.getString(titleResourceId);
            return this;
        }

        public SimpleDialogBuilder setTitle(String title) {
            this.mTitle = title;
            return this;
        }

        public SimpleDialogBuilder setMessage(int messageResourceId) {
            this.mMessage = this.mContext.getText(messageResourceId);
            return this;
        }

        public SimpleDialogBuilder setMessage(int resourceId, Object ... formatArgs) {
            this.mMessage = Html.fromHtml((String)String.format(Html.toHtml((Spanned)new SpannedString(this.mContext.getText(resourceId))), formatArgs));
            return this;
        }

        public SimpleDialogBuilder setMessage(CharSequence message) {
            this.mMessage = message;
            return this;
        }

        public SimpleDialogBuilder setPositiveButtonText(int textResourceId) {
            this.mPositiveButtonText = this.mContext.getString(textResourceId);
            return this;
        }

        public SimpleDialogBuilder setPositiveButtonText(String text) {
            this.mPositiveButtonText = text;
            return this;
        }

        public SimpleDialogBuilder setNegativeButtonText(int textResourceId) {
            this.mNegativeButtonText = this.mContext.getString(textResourceId);
            return this;
        }

        public SimpleDialogBuilder setNegativeButtonText(String text) {
            this.mNegativeButtonText = text;
            return this;
        }

        public SimpleDialogBuilder setNeutralButtonText(int textResourceId) {
            this.mNeutralButtonText = this.mContext.getString(textResourceId);
            return this;
        }

        public SimpleDialogBuilder setNeutralButtonText(String text) {
            this.mNeutralButtonText = text;
            return this;
        }

        @Override
        protected Bundle prepareArguments() {
            Bundle args = new Bundle();
            args.putCharSequence(SimpleDialogFragment.ARG_MESSAGE, this.mMessage);
            args.putString(SimpleDialogFragment.ARG_TITLE, this.mTitle);
            args.putString(SimpleDialogFragment.ARG_POSITIVE_BUTTON, this.mPositiveButtonText);
            args.putString(SimpleDialogFragment.ARG_NEGATIVE_BUTTON, this.mNegativeButtonText);
            args.putString(SimpleDialogFragment.ARG_NEUTRAL_BUTTON, this.mNeutralButtonText);
            return args;
        }
    }
}

