/*
 * Decompiled with CFR 0.152.
 */
package com.avast.android.dialogs.fragment;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import com.avast.android.dialogs.R;
import com.avast.android.dialogs.core.BaseDialogBuilder;
import com.avast.android.dialogs.core.BaseDialogFragment;
import com.avast.android.dialogs.iface.IListDialogListener;

public class ListDialogFragment
extends BaseDialogFragment {
    private static String ARG_ITEMS = "items";

    public static SimpleListDialogBuilder createBuilder(Context context, FragmentManager fragmentManager) {
        return new SimpleListDialogBuilder(context, fragmentManager);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (this.getArguments() == null) {
            throw new IllegalArgumentException("use SimpleListDialogBuilder to construct this dialog");
        }
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        IListDialogListener onListItemSelectedListener = this.getDialogListener();
        if (onListItemSelectedListener != null) {
            onListItemSelectedListener.onCancelled();
        }
    }

    @Override
    protected BaseDialogFragment.Builder build(BaseDialogFragment.Builder builder) {
        Object[] items;
        String title = this.getTitle();
        if (!TextUtils.isEmpty((CharSequence)title)) {
            builder.setTitle(title);
        }
        if (!TextUtils.isEmpty((CharSequence)this.getPositiveButtonText())) {
            builder.setPositiveButton(this.getPositiveButtonText(), new View.OnClickListener(){

                public void onClick(View view) {
                    IListDialogListener onListItemSelectedListener = ListDialogFragment.this.getDialogListener();
                    if (onListItemSelectedListener != null) {
                        onListItemSelectedListener.onCancelled();
                    }
                    ListDialogFragment.this.dismiss();
                }
            });
        }
        if ((items = this.getItems()) != null && items.length > 0) {
            ArrayAdapter adapter = new ArrayAdapter((Context)this.getActivity(), R.layout.sdl_list_item, R.id.sdl_text, items);
            builder.setItems((ListAdapter)adapter, 0, new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    IListDialogListener onListItemSelectedListener = ListDialogFragment.this.getDialogListener();
                    if (onListItemSelectedListener != null) {
                        onListItemSelectedListener.onListItemSelected(ListDialogFragment.this.getItems()[position], position);
                        ListDialogFragment.this.dismiss();
                    }
                }
            });
        }
        return builder;
    }

    private IListDialogListener getDialogListener() {
        Fragment targetFragment = this.getTargetFragment();
        if (targetFragment != null) {
            if (targetFragment instanceof IListDialogListener) {
                return (IListDialogListener)targetFragment;
            }
        } else if (this.getActivity() instanceof IListDialogListener) {
            return (IListDialogListener)this.getActivity();
        }
        return null;
    }

    private String getTitle() {
        return this.getArguments().getString("title");
    }

    private String[] getItems() {
        return this.getArguments().getStringArray(ARG_ITEMS);
    }

    private String getPositiveButtonText() {
        return this.getArguments().getString("positive_button");
    }

    public static class SimpleListDialogBuilder
    extends BaseDialogBuilder<SimpleListDialogBuilder> {
        private String title;
        private String[] items;
        private String cancelButtonText;

        public SimpleListDialogBuilder(Context context, FragmentManager fragmentManager) {
            super(context, fragmentManager, ListDialogFragment.class);
        }

        @Override
        protected SimpleListDialogBuilder self() {
            return this;
        }

        private Resources getResources() {
            return this.mContext.getResources();
        }

        public SimpleListDialogBuilder setTitle(String title) {
            this.title = title;
            return this;
        }

        public SimpleListDialogBuilder setTitle(int titleResID) {
            this.title = this.getResources().getString(titleResID);
            return this;
        }

        public SimpleListDialogBuilder setItems(String[] items) {
            this.items = items;
            return this;
        }

        public SimpleListDialogBuilder setItems(int itemsArrayResID) {
            this.items = this.getResources().getStringArray(itemsArrayResID);
            return this;
        }

        public SimpleListDialogBuilder setCancelButtonText(String text) {
            this.cancelButtonText = text;
            return this;
        }

        public SimpleListDialogBuilder setCancelButtonText(int cancelBttTextResID) {
            this.cancelButtonText = this.getResources().getString(cancelBttTextResID);
            return this;
        }

        @Override
        public ListDialogFragment show() {
            return (ListDialogFragment)super.show();
        }

        @Override
        protected Bundle prepareArguments() {
            Bundle args = new Bundle();
            args.putString("title", this.title);
            args.putString("positive_button", this.cancelButtonText);
            args.putStringArray(ARG_ITEMS, this.items);
            return args;
        }
    }
}

