/*
 * Decompiled with CFR 0.152.
 */
package com.avast.android.dialogs.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.DatePicker;
import com.avast.android.dialogs.R;
import com.avast.android.dialogs.core.BaseDialogBuilder;
import com.avast.android.dialogs.core.BaseDialogFragment;
import com.avast.android.dialogs.iface.IDateDialogCancelListener;
import com.avast.android.dialogs.iface.IDateDialogListener;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DatePickerDialogFragment
extends BaseDialogFragment {
    protected static final String ARG_ZONE = "zone";
    protected static final String ARG_TITLE = "title";
    protected static final String ARG_POSITIVE_BUTTON = "positive_button";
    protected static final String ARG_NEGATIVE_BUTTON = "negative_button";
    protected static final String ARG_DATE = "date";
    protected static final String ARG_24H = "24h";
    DatePicker mDatePicker;
    Calendar mCalendar;
    private int mRequestCode;

    public static SimpleDialogBuilder createBuilder(Context context, FragmentManager fragmentManager) {
        return new SimpleDialogBuilder(context, fragmentManager, (Class<? extends DatePickerDialogFragment>)DatePickerDialogFragment.class);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Fragment targetFragment = this.getTargetFragment();
        if (targetFragment != null) {
            this.mRequestCode = this.getTargetRequestCode();
        } else {
            Bundle args = this.getArguments();
            if (args != null) {
                this.mRequestCode = args.getInt("request_code", 0);
            }
        }
    }

    protected IDateDialogListener getDialogListener() {
        Fragment targetFragment = this.getTargetFragment();
        if (targetFragment != null) {
            if (targetFragment instanceof IDateDialogListener) {
                return (IDateDialogListener)targetFragment;
            }
        } else if (this.getActivity() instanceof IDateDialogListener) {
            return (IDateDialogListener)this.getActivity();
        }
        return null;
    }

    protected IDateDialogCancelListener getCancelListener() {
        Fragment targetFragment = this.getTargetFragment();
        if (targetFragment != null) {
            if (targetFragment instanceof IDateDialogCancelListener) {
                return (IDateDialogCancelListener)targetFragment;
            }
        } else if (this.getActivity() instanceof IDateDialogCancelListener) {
            return (IDateDialogCancelListener)this.getActivity();
        }
        return null;
    }

    @Override
    protected BaseDialogFragment.Builder build(BaseDialogFragment.Builder builder) {
        String negativeButtonText;
        String positiveButtonText;
        String title = this.getTitle();
        if (!TextUtils.isEmpty((CharSequence)title)) {
            builder.setTitle(title);
        }
        if (!TextUtils.isEmpty((CharSequence)(positiveButtonText = this.getPositiveButtonText()))) {
            builder.setPositiveButton(positiveButtonText, new View.OnClickListener(){

                public void onClick(View view) {
                    IDateDialogListener listener = DatePickerDialogFragment.this.getDialogListener();
                    if (listener != null) {
                        listener.onPositiveButtonClicked(DatePickerDialogFragment.this.mRequestCode, DatePickerDialogFragment.this.getDate());
                    }
                    DatePickerDialogFragment.this.dismiss();
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)(negativeButtonText = this.getNegativeButtonText()))) {
            builder.setNegativeButton(negativeButtonText, new View.OnClickListener(){

                public void onClick(View view) {
                    IDateDialogListener listener = DatePickerDialogFragment.this.getDialogListener();
                    if (listener != null) {
                        listener.onNegativeButtonClicked(DatePickerDialogFragment.this.mRequestCode, DatePickerDialogFragment.this.getDate());
                    }
                    DatePickerDialogFragment.this.dismiss();
                }
            });
        }
        this.mDatePicker = (DatePicker)LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.sdl_datepicker, null);
        builder.setView((View)this.mDatePicker);
        TimeZone zone = TimeZone.getTimeZone(this.getArguments().getString(ARG_ZONE));
        this.mCalendar = Calendar.getInstance(zone);
        this.mCalendar.setTimeInMillis(this.getArguments().getLong(ARG_DATE, System.currentTimeMillis()));
        this.mDatePicker.updateDate(this.mCalendar.get(1), this.mCalendar.get(2), this.mCalendar.get(5));
        return builder;
    }

    protected String getTitle() {
        return this.getArguments().getString(ARG_TITLE);
    }

    protected String getPositiveButtonText() {
        return this.getArguments().getString(ARG_POSITIVE_BUTTON);
    }

    protected String getNegativeButtonText() {
        return this.getArguments().getString(ARG_NEGATIVE_BUTTON);
    }

    public Date getDate() {
        this.mCalendar.set(1, this.mDatePicker.getYear());
        this.mCalendar.set(2, this.mDatePicker.getMonth());
        this.mCalendar.set(5, this.mDatePicker.getDayOfMonth());
        return this.mCalendar.getTime();
    }

    public static class SimpleDialogBuilder
    extends BaseDialogBuilder<SimpleDialogBuilder> {
        Date mDate = new Date();
        String mTimeZone = null;
        private String mTitle;
        private String mPositiveButtonText;
        private String mNegativeButtonText;
        private boolean mShowDefaultButton = true;
        private boolean m24h;

        protected SimpleDialogBuilder(Context context, FragmentManager fragmentManager, Class<? extends DatePickerDialogFragment> clazz) {
            super(context, fragmentManager, clazz);
        }

        public SimpleDialogBuilder setTitle(int titleResourceId) {
            this.mTitle = this.mContext.getString(titleResourceId);
            return this;
        }

        public SimpleDialogBuilder setTitle(String title) {
            this.mTitle = title;
            return this;
        }

        public SimpleDialogBuilder setPositiveButtonText(int textResourceId) {
            this.mPositiveButtonText = this.mContext.getString(textResourceId);
            return this;
        }

        public SimpleDialogBuilder setPositiveButtonText(String text) {
            this.mPositiveButtonText = text;
            return this;
        }

        public SimpleDialogBuilder setNegativeButtonText(int textResourceId) {
            this.mNegativeButtonText = this.mContext.getString(textResourceId);
            return this;
        }

        public SimpleDialogBuilder setNegativeButtonText(String text) {
            this.mNegativeButtonText = text;
            return this;
        }

        public SimpleDialogBuilder setDate(Date date) {
            this.mDate = date;
            return this;
        }

        public SimpleDialogBuilder setTimeZone(String zone) {
            this.mTimeZone = zone;
            return this;
        }

        public SimpleDialogBuilder set24hour(boolean state) {
            this.m24h = state;
            return this;
        }

        @Override
        protected Bundle prepareArguments() {
            Bundle args = new Bundle();
            args.putString(DatePickerDialogFragment.ARG_TITLE, this.mTitle);
            args.putString(DatePickerDialogFragment.ARG_POSITIVE_BUTTON, this.mPositiveButtonText);
            args.putString(DatePickerDialogFragment.ARG_NEGATIVE_BUTTON, this.mNegativeButtonText);
            args.putLong(DatePickerDialogFragment.ARG_DATE, this.mDate.getTime());
            args.putBoolean(DatePickerDialogFragment.ARG_24H, this.m24h);
            if (this.mTimeZone != null) {
                args.putString(DatePickerDialogFragment.ARG_ZONE, this.mTimeZone);
            } else {
                args.putString(DatePickerDialogFragment.ARG_ZONE, "GMT");
            }
            return args;
        }

        @Override
        protected SimpleDialogBuilder self() {
            return this;
        }
    }
}

