/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.analysis;

import com.autonomousapps.internal.analysis.IssueListener;
import com.autonomousapps.internal.asm.AnnotationVisitor;
import com.autonomousapps.internal.asm.ClassVisitor;
import com.autonomousapps.internal.asm.MethodVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JI\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\r2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012JA\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0010\u0010\u0016\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/autonomousapps/internal/analysis/ClassAnalyzer;", "Lcom/autonomousapps/internal/asm/ClassVisitor;", "listener", "Lcom/autonomousapps/internal/analysis/IssueListener;", "logger", "Lorg/gradle/api/logging/Logger;", "(Lcom/autonomousapps/internal/analysis/IssueListener;Lorg/gradle/api/logging/Logger;)V", "visit", "", "version", "", "access", "name", "", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitMethod", "Lcom/autonomousapps/internal/asm/MethodVisitor;", "descriptor", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lcom/autonomousapps/internal/asm/MethodVisitor;", "MethodAnalyzer", "plugin-best-practices-plugin"})
public final class ClassAnalyzer
extends ClassVisitor {
    @NotNull
    private final IssueListener listener;
    @NotNull
    private final Logger logger;

    public ClassAnalyzer(@NotNull IssueListener listener, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(589824);
        this.listener = listener;
        this.logger = logger;
    }

    public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.logger.debug("ClassAnalyzer#visit: " + name + " super=" + superName);
        Object object = interfaces;
        if (interfaces == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        this.listener.visitClass(name, superName, (List<String>)object);
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.logger.debug("- visitMethod: name=" + name + " descriptor=" + descriptor + " signature=" + signature + " access=" + access);
        this.listener.visitMethod(name, descriptor);
        return new MethodAnalyzer(this.logger, this.listener);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/autonomousapps/internal/analysis/ClassAnalyzer$MethodAnalyzer;", "Lcom/autonomousapps/internal/asm/MethodVisitor;", "logger", "Lorg/gradle/api/logging/Logger;", "listener", "Lcom/autonomousapps/internal/analysis/IssueListener;", "(Lorg/gradle/api/logging/Logger;Lcom/autonomousapps/internal/analysis/IssueListener;)V", "visitAnnotation", "Lcom/autonomousapps/internal/asm/AnnotationVisitor;", "descriptor", "", "visible", "", "visitEnd", "", "visitMethodInsn", "opcode", "", "owner", "name", "isInterface", "plugin-best-practices-plugin"})
    public static final class MethodAnalyzer
    extends MethodVisitor {
        @NotNull
        private final Logger logger;
        @NotNull
        private final IssueListener listener;

        public MethodAnalyzer(@NotNull Logger logger, @NotNull IssueListener listener) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            super(589824);
            this.logger = logger;
            this.listener = listener;
        }

        public void visitEnd() {
            this.listener.visitMethodEnd();
        }

        @Nullable
        public AnnotationVisitor visitAnnotation(@NotNull String descriptor, boolean visible) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.logger.debug("  - visitAnnotation: descriptor=" + descriptor + " visible=" + visible);
            this.listener.visitMethodAnnotation(descriptor);
            return null;
        }

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String descriptor, boolean isInterface) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.logger.debug("  - visitMethodInsn: owner=" + owner + " name=" + name + " descriptor=" + descriptor + " opcode=" + opcode);
            this.listener.visitMethodInstruction(owner, name, descriptor);
        }
    }
}

