/*
 * Decompiled with CFR 0.152.
 */
package com.auth0;

import com.auth0.authentication.result.UserIdentity;
import com.auth0.authentication.result.UserProfile;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Auth0User
implements Principal,
Serializable {
    private static final long serialVersionUID = 2371882820082543721L;
    private String userId;
    private String name;
    private String nickname;
    private String picture;
    private String email;
    private boolean emailVerified;
    private String givenName;
    private String familyName;
    private Map<String, Object> userMetadata;
    private Map<String, Object> appMetadata;
    private Date createdAt;
    private List<UserIdentity> identities;
    private Map<String, Object> extraInfo;
    private List<String> roles = new ArrayList<String>();
    private List<String> groups = new ArrayList<String>();

    public Auth0User(UserProfile userProfile) {
        this.userId = userProfile.getId();
        this.name = userProfile.getName();
        this.nickname = userProfile.getNickname();
        this.picture = userProfile.getPictureURL();
        this.email = userProfile.getEmail();
        this.emailVerified = userProfile.isEmailVerified();
        this.givenName = userProfile.getGivenName();
        this.familyName = userProfile.getFamilyName();
        this.userMetadata = userProfile.getUserMetadata();
        this.appMetadata = userProfile.getAppMetadata();
        this.createdAt = userProfile.getCreatedAt();
        this.identities = userProfile.getIdentities();
        this.extraInfo = userProfile.getExtraInfo();
        if (this.extraInfo != null && this.extraInfo.containsKey("roles")) {
            this.roles = (List)this.extraInfo.get("roles");
        }
        if (this.extraInfo != null && this.extraInfo.containsKey("groups")) {
            this.groups = (List)this.extraInfo.get("groups");
        }
    }

    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getPicture() {
        return this.picture;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public Map<String, Object> getUserMetadata() {
        return this.userMetadata;
    }

    public Map<String, Object> getAppMetadata() {
        return this.appMetadata;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public List<UserIdentity> getIdentities() {
        return this.identities;
    }

    public Map<String, Object> getExtraInfo() {
        return this.extraInfo;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Auth0User rhs = (Auth0User)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.userId, (Object)rhs.userId).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.userId).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("userId", (Object)this.userId).append("name", (Object)this.name).append("email", (Object)this.email).toString();
    }
}

