/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.org.bouncycastle.crypto.prng;

import com.auth0.jwt.internal.org.bouncycastle.crypto.BlockCipher;
import com.auth0.jwt.internal.org.bouncycastle.crypto.params.KeyParameter;
import com.auth0.jwt.internal.org.bouncycastle.crypto.prng.BasicEntropySourceProvider;
import com.auth0.jwt.internal.org.bouncycastle.crypto.prng.EntropySourceProvider;
import com.auth0.jwt.internal.org.bouncycastle.crypto.prng.X931RNG;
import com.auth0.jwt.internal.org.bouncycastle.crypto.prng.X931SecureRandom;
import com.auth0.jwt.internal.org.bouncycastle.util.Pack;
import java.security.SecureRandom;

public class X931SecureRandomBuilder {
    private SecureRandom random;
    private EntropySourceProvider entropySourceProvider;
    private BlockCipher engine;
    private byte[] dateTimeVector;

    public X931SecureRandomBuilder() {
        this(new SecureRandom(), false);
    }

    public X931SecureRandomBuilder(SecureRandom secureRandom, boolean bl) {
        this.random = secureRandom;
        this.entropySourceProvider = new BasicEntropySourceProvider(this.random, bl);
    }

    public X931SecureRandomBuilder(EntropySourceProvider entropySourceProvider) {
        this.random = null;
        this.entropySourceProvider = entropySourceProvider;
    }

    public X931SecureRandomBuilder setDateTimeVector(byte[] byArray) {
        this.dateTimeVector = byArray;
        return this;
    }

    public X931SecureRandom build(BlockCipher blockCipher, KeyParameter keyParameter, boolean bl) {
        this.engine = blockCipher;
        if (this.dateTimeVector == null) {
            if (blockCipher.getBlockSize() == 8) {
                this.dateTimeVector = Pack.longToBigEndian(System.currentTimeMillis());
            } else {
                this.dateTimeVector = new byte[blockCipher.getBlockSize()];
                byte[] byArray = Pack.longToBigEndian(System.currentTimeMillis());
                System.arraycopy(byArray, 0, this.dateTimeVector, 0, byArray.length);
            }
        }
        blockCipher.init(true, keyParameter);
        return new X931SecureRandom(this.random, new X931RNG(blockCipher, this.dateTimeVector, this.entropySourceProvider.get(blockCipher.getBlockSize() * 8)), bl);
    }
}

