/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.org.apache.commons.lang3.text;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public abstract class StrLookup<V> {
    private static final StrLookup<String> NONE_LOOKUP = new MapStrLookup<String>(null);

    public static StrLookup<?> noneLookup() {
        return NONE_LOOKUP;
    }

    private static Properties copyProperties(Properties input) {
        if (input == null) {
            return null;
        }
        Properties output = new Properties();
        Enumeration<?> propertyNames = input.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            output.setProperty(propertyName, input.getProperty(propertyName));
        }
        return output;
    }

    public static StrLookup<String> systemPropertiesLookup() {
        Properties properties;
        Properties systemProperties = null;
        try {
            systemProperties = System.getProperties();
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        Properties propertiesMap = properties = StrLookup.copyProperties(systemProperties);
        return new MapStrLookup<Object>(propertiesMap);
    }

    public static <V> StrLookup<V> mapLookup(Map<String, V> map) {
        return new MapStrLookup<V>(map);
    }

    protected StrLookup() {
    }

    public abstract String lookup(String var1);

    static class MapStrLookup<V>
    extends StrLookup<V> {
        private final Map<String, V> map;

        MapStrLookup(Map<String, V> map) {
            this.map = map;
        }

        @Override
        public String lookup(String key) {
            if (this.map == null) {
                return null;
            }
            V obj = this.map.get(key);
            if (obj == null) {
                return null;
            }
            return obj.toString();
        }
    }
}

