/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;

public class ResumePreviousTransactionSubTxAwareParticipant
implements SubTxAwareParticipant {
    private static final Logger LOGGER = LoggerFactory.createLogger(ResumePreviousTransactionSubTxAwareParticipant.class);
    private CompositeTransaction previous;

    public ResumePreviousTransactionSubTxAwareParticipant(CompositeTransaction previous) {
        if (previous == null) {
            throw new IllegalArgumentException("Previous transaction is null?");
        }
        this.previous = previous;
    }

    private void resume() {
        CompositeTransactionManager ctm = Configuration.getCompositeTransactionManager();
        if (ctm == null) {
            LOGGER.logWarning("ResumePreviousTransactionSubTxAwareParticipant: no transaction manager found?");
        } else {
            try {
                ctm.resume(this.previous);
            }
            catch (Exception error) {
                LOGGER.logWarning("ResumePreviousTransactionSubTxAwareParticipant: could not resume previous transaction", (Throwable)error);
            }
        }
    }

    public void committed(CompositeTransaction tx) {
        this.resume();
    }

    public void rolledback(CompositeTransaction tx) {
        this.resume();
    }
}

