/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.xmlrpc;

import com.atlassian.xmlrpc.BinderPropertyHandlerMapping;
import com.atlassian.xmlrpc.BinderTypeFactory;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.common.TypeConverterFactory;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcController;
import org.apache.xmlrpc.server.PropertyHandlerMapping;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;
import org.apache.xmlrpc.server.XmlRpcServerConfig;
import org.apache.xmlrpc.server.XmlRpcServerConfigImpl;
import org.apache.xmlrpc.webserver.XmlRpcServlet;
import org.apache.xmlrpc.webserver.XmlRpcServletServer;

public class BinderXmlRpcServlet
extends XmlRpcServlet {
    private XmlRpcServletServer server;

    public void init(ServletConfig pConfig) throws ServletException {
        super.init(pConfig);
    }

    public XmlRpcServletServer getXmlRpcServletServer() {
        if (this.server == null) {
            this.server = super.getXmlRpcServletServer();
            this.server.setTypeFactory((TypeFactory)new BinderTypeFactory((XmlRpcController)this.server));
            XmlRpcServerConfigImpl config = new XmlRpcServerConfigImpl();
            config.setEnabledForExceptions(true);
            config.setEnabledForExtensions(true);
            this.server.setConfig((XmlRpcServerConfig)config);
        }
        return this.server;
    }

    protected PropertyHandlerMapping newPropertyHandlerMapping(URL url) throws IOException, XmlRpcException {
        TypeConverterFactory converterFactory;
        BinderPropertyHandlerMapping mapping = new BinderPropertyHandlerMapping();
        mapping.setAuthenticationHandler(this.getAuthenticationHandler());
        RequestProcessorFactoryFactory requestProcessorFactoryFactory = this.getRequestProcessorFactoryFactory();
        if (requestProcessorFactoryFactory != null) {
            mapping.setRequestProcessorFactoryFactory(requestProcessorFactoryFactory);
        }
        if ((converterFactory = this.getTypeConverterFactory()) != null) {
            mapping.setTypeConverterFactory(converterFactory);
        } else {
            mapping.setTypeConverterFactory(this.getXmlRpcServletServer().getTypeConverterFactory());
        }
        if (url != null) {
            mapping.load(Thread.currentThread().getContextClassLoader(), url);
        }
        mapping.setVoidMethodEnabled(true);
        return mapping;
    }
}

