/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.xmlrpc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;

public class BinderRequestProcessorFactoryFactory
implements RequestProcessorFactoryFactory {
    private final Map<Class, BinderRequestProcessorFactory> services = new HashMap<Class, BinderRequestProcessorFactory>();

    public BinderRequestProcessorFactoryFactory(List serviceList) {
        for (Object service : serviceList) {
            this.services.put(service.getClass(), new BinderRequestProcessorFactory(service.getClass(), service));
        }
    }

    public RequestProcessorFactoryFactory.RequestProcessorFactory getRequestProcessorFactory(Class pClass) throws XmlRpcException {
        BinderRequestProcessorFactory processorFactory = this.services.get(pClass);
        if (processorFactory == null) {
            throw new XmlRpcException("Could not find service object instance for type " + pClass.getName());
        }
        return processorFactory;
    }

    private class BinderRequestProcessorFactory
    implements RequestProcessorFactoryFactory.RequestProcessorFactory {
        private final Class pType;
        private final Object serviceObject;

        public BinderRequestProcessorFactory(Class pType, Object serviceObject) {
            this.pType = pType;
            this.serviceObject = serviceObject;
        }

        public Object getRequestProcessor(XmlRpcRequest request) throws XmlRpcException {
            return this.serviceObject;
        }
    }
}

