/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity.htmlsafe.introspection;

import com.atlassian.velocity.htmlsafe.annotations.ReturnValueAnnotation;
import com.atlassian.velocity.htmlsafe.introspection.MethodAnnotator;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReturnValueAnnotator
implements MethodAnnotator {
    private static final Logger log = LoggerFactory.getLogger(ReturnValueAnnotator.class);
    private final Cache<Annotation, Boolean> annotationCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Annotation, Boolean>(){

        public Boolean load(Annotation annotation) {
            return annotation.annotationType().isAnnotationPresent(ReturnValueAnnotation.class);
        }
    });

    ReturnValueAnnotator() {
    }

    @Override
    public Collection<Annotation> getAnnotationsForMethod(Method method) {
        HashSet<Annotation> returnValueAnnotations = new HashSet<Annotation>();
        for (Annotation annotation : method.getAnnotations()) {
            if (!((Boolean)this.annotationCache.getUnchecked((Object)annotation)).booleanValue()) continue;
            returnValueAnnotations.add(annotation);
        }
        return Collections.unmodifiableCollection(returnValueAnnotations);
    }
}

