/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity.htmlsafe.introspection;

import com.atlassian.velocity.htmlsafe.introspection.MethodAnnotator;
import com.atlassian.velocity.htmlsafe.util.Check;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodAnnotatorChain
implements MethodAnnotator {
    private final List<MethodAnnotator> ANNOTATOR_CHAIN;

    public MethodAnnotatorChain(List<MethodAnnotator> annotators) {
        Check.notNull(annotators, "annotators must not be null");
        this.ANNOTATOR_CHAIN = Collections.unmodifiableList(new LinkedList<MethodAnnotator>(annotators));
    }

    @Override
    public Collection<Annotation> getAnnotationsForMethod(Method method) {
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        for (MethodAnnotator annotator : this.ANNOTATOR_CHAIN) {
            annotations.addAll(annotator.getAnnotationsForMethod(method));
        }
        return annotations;
    }
}

