package com.atlassian.vcache.internal;

/**
 * A metric for tracking {@link Long} values.
 *
 * @since 1.0.0
 */
public interface LongMetric {
    /**
     * Returns the number of samples recorded.
     *
     * @return the number of samples recorded.
     */
    long getSampleCount();

    /**
     * Returns the total of all samples recorded.
     *
     * @return the total of all samples recorded.
     */
    long getSamplesTotal();

    /**
     * Returns the minimum sample value recorded.
     *
     * @return the minimum sample value recorded.
     */
    long getMinSample();

    /**
     * Returns the maximum sample value recorded.
     *
     * @return the maximum sample value recorded.
     */
    long getMaxSample();
}
