package com.atlassian.vcache.internal;

import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.TransactionalExternalCache;

import javax.annotation.Nonnull;

/**
 * Details for a configured {@link com.atlassian.vcache.ExternalCache}
 *
 * @since 1.0
 */
public interface ExternalCacheDetails {
    /**
     * Represents the different buffering policies for {@link com.atlassian.vcache.ExternalCache} instances.
     */
    enum BufferPolicy {
        /**
         * Corresponds to {@link DirectExternalCache}.
         */
        NEVER(false, false),
        /**
         * Corresponds to {@link StableReadExternalCache}.
         */
        READ_ONLY(true, false),
        /**
         * Corresponds to {@link TransactionalExternalCache}.
         */
        FULLY(true, true);

        private final boolean readBuffered;
        private final boolean writeBuffered;

        BufferPolicy(boolean readBuffered, boolean writeBuffered) {
            this.readBuffered = readBuffered;
            this.writeBuffered = writeBuffered;
        }

        boolean isReadBuffered() {
            return readBuffered;
        }

        boolean isWriteBuffered() {
            return writeBuffered;
        }
    }

    /**
     * The name of the cache, uniquely identifies this cache.
     *
     * @return the name of the cache
     */
    @Nonnull
    String getName();

    @Nonnull
    BufferPolicy getPolicy();

    @Nonnull
    ExternalCacheSettings getSettings();
}
