package com.atlassian.vcache;

import com.atlassian.annotations.PublicApi;

/**
 * Represents the different policies for a put operation on a cache.
 *
 * @since 1.0
 */
@PublicApi
public enum PutPolicy {
    /**
     * Only put the value if no value is currently associated with the key.
     */
    ADD_ONLY,
    /**
     * Only put the value if a value is currently associated with the key.
     */
    REPLACE_ONLY,
    /**
     * Always put the value, regardless of whether a value is currently associated or not.
     */
    PUT_ALWAYS
}
