package com.atlassian.vcache;

import com.atlassian.annotations.PublicApi;

import javax.annotation.Nonnull;

/**
 * Represents a value that has an associated {@link CasIdentifier} that can be used for "compare-and-swap" operations.
 *
 * @param <T> the type of the value
 * @since 1.0
 */
@PublicApi
public interface IdentifiedValue<T> {
    /**
     * Returns the value.
     *
     * @return the value.
     */
    @Nonnull
    T value();

    /**
     * Returns the {@link CasIdentifier} associated with the value.
     *
     * @return the {@link CasIdentifier} associated with the value.
     */
    @Nonnull
    CasIdentifier identifier();
}
