/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.Watchdog;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nonnull;

class WatchdogAwareOutputStream
extends FilterOutputStream {
    private final Watchdog watchdog;

    WatchdogAwareOutputStream(OutputStream out, Watchdog watchdog) {
        super(out);
        this.watchdog = Objects.requireNonNull(watchdog, "watchdog");
    }

    @Override
    public void write(int b) throws IOException {
        this.watchdog.resetWatchdog();
        super.write(b);
    }

    @Override
    public void write(@Nonnull byte[] b) throws IOException {
        this.watchdog.resetWatchdog();
        super.write(b);
    }

    @Override
    public void write(@Nonnull byte[] b, int off, int len) throws IOException {
        this.watchdog.resetWatchdog();
        super.write(b, off, len);
    }
}

