/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

public class ProcessException
extends Exception {
    int exitCode;

    public ProcessException(String message, Throwable cause) {
        super(message, cause);
        this.exitCode = ProcessException.extractExitCode(cause);
    }

    private static int extractExitCode(Throwable cause) {
        while (cause != null) {
            if (cause instanceof ProcessException) {
                return ((ProcessException)cause).getExitCode();
            }
            cause = cause.getCause();
        }
        return 0;
    }

    public ProcessException(String message) {
        super(message);
    }

    public ProcessException(Throwable e) {
        super(e);
        this.exitCode = ProcessException.extractExitCode(e);
    }

    public ProcessException(String message, int exitCode) {
        super(message);
        this.exitCode = exitCode;
    }

    public int getExitCode() {
        return this.exitCode;
    }
}

