/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.ProcessException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class CopyOutputHandler
extends BaseOutputHandler {
    private final OutputStream dest;
    private final int bufferSize;

    public CopyOutputHandler(OutputStream dest) {
        this(dest, 1024);
    }

    public CopyOutputHandler(OutputStream dest, int bufferSize) {
        this.dest = dest;
        this.bufferSize = bufferSize;
    }

    public void process(InputStream output) throws ProcessException {
        try {
            int num;
            byte[] buffer = new byte[this.bufferSize];
            while ((num = output.read(buffer)) != -1) {
                this.resetWatchdog();
                this.dest.write(buffer, 0, num);
            }
        }
        catch (InterruptedIOException e) {
        }
        catch (IOException e) {
            throw new ProcessException(e);
        }
    }
}

