/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.DefaultExternalProcessFactory;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessFactory;
import com.atlassian.utils.process.ExternalProcessSettings;
import com.atlassian.utils.process.InputHandler;
import com.atlassian.utils.process.LoggingProcessMonitor;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.PluggableProcessHandler;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import com.atlassian.utils.process.StringObfuscator;
import com.atlassian.utils.process.StringOutputHandler;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ExternalProcessBuilder {
    private static ExternalProcessFactory externalProcessFactory = new DefaultExternalProcessFactory();
    private final ExternalProcessSettings settings = new ExternalProcessSettings();

    public static ExternalProcessFactory getExternalProcessFactory() {
        return externalProcessFactory;
    }

    public static void setExternalProcessFactory(ExternalProcessFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        externalProcessFactory = factory;
    }

    public ExternalProcessBuilder addMonitor(ProcessMonitor ... monitors) {
        this.settings.getMonitors().addAll(Arrays.asList(monitors));
        return this;
    }

    public ExternalProcess build() {
        return externalProcessFactory.create(this.settings);
    }

    public ExternalProcessBuilder command(List<String> command) {
        this.settings.setCommand(command);
        return this;
    }

    public ExternalProcessBuilder command(List<String> command, File workingDir) {
        this.settings.setWorkingDirectory(workingDir);
        return this.command(command);
    }

    public ExternalProcessBuilder command(List<String> command, File workingDir, long timeout) {
        this.idleTimeout(timeout);
        return this.command(command, workingDir);
    }

    public ExternalProcessBuilder env(String variable, String value) {
        this.settings.getEnvironment().put(variable, value);
        return this;
    }

    public ExternalProcessBuilder env(Map<String, String> environment) {
        this.settings.getEnvironment().putAll(environment);
        return this;
    }

    public ExternalProcessBuilder executionTimeout(long executionTimeout) {
        this.settings.setExecutionTimeout(executionTimeout);
        return this;
    }

    public ExternalProcessBuilder handler(ProcessHandler handler) {
        this.settings.setProcessHandler(handler);
        return this;
    }

    public ExternalProcessBuilder handlers(OutputHandler output) {
        return this.handlers(null, output, null);
    }

    public ExternalProcessBuilder handlers(OutputHandler output, OutputHandler error) {
        return this.handlers(null, output, error);
    }

    public ExternalProcessBuilder handlers(InputHandler input, OutputHandler output) {
        return this.handlers(input, output, null);
    }

    public ExternalProcessBuilder handlers(InputHandler input, OutputHandler output, OutputHandler error) {
        if (error == null) {
            error = new StringOutputHandler();
        }
        return this.handler(new PluggableProcessHandler(input, output, error));
    }

    public ExternalProcessBuilder idleTimeout(long idleTimeout) {
        this.settings.setIdleTimeout(idleTimeout);
        return this;
    }

    public ExternalProcessBuilder log(Logger logger, Priority priority) {
        return this.log(logger, priority, null);
    }

    public ExternalProcessBuilder log(Logger logger, Priority priority, StringObfuscator obfuscator) {
        return this.addMonitor(new LoggingProcessMonitor(logger, priority, obfuscator));
    }

    public ExternalProcessBuilder suppressSpecialWindowsBehaviour() {
        return this;
    }

    @Deprecated
    public ExternalProcessBuilder timeout(long timeout) {
        return this.idleTimeout(timeout);
    }

    public ExternalProcessBuilder useWindowsEncodingWorkaround() {
        return this;
    }

    public ExternalProcessBuilder useQuotesInBatArgumentsWorkaround() {
        this.settings.setUseQuotesInBatArgumentsWorkaround(true);
        return this;
    }

    public ExternalProcessBuilder escapeInternalDoubleQuotesOnWindows() {
        this.settings.setEscapeInternalDoubleQuotesOnWindows(true);
        return this;
    }
}

