/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache.internal;

import com.atlassian.util.contentcache.CacheAccess;
import com.atlassian.util.contentcache.CacheEntryExpiredException;
import com.atlassian.util.contentcache.CacheEntryStatistics;
import com.atlassian.util.contentcache.CacheResult;
import com.atlassian.util.contentcache.ContentProvider;
import com.atlassian.util.contentcache.StreamPumper;
import com.atlassian.util.contentcache.internal.CacheWriteState;
import com.atlassian.util.contentcache.internal.DefaultCacheEntryStatistics;
import com.atlassian.util.contentcache.internal.DefaultStreamPump;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheEntry {
    public static final Function<AbstractCacheEntry, CacheEntryStatistics> TO_STATISTICS = new Function<AbstractCacheEntry, CacheEntryStatistics>(){

        public CacheEntryStatistics apply(AbstractCacheEntry cacheEntry) {
            return cacheEntry.getStatistics();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(AbstractCacheEntry.class);
    private static final long MAX_WAIT_FOR_DATA_MS = TimeUnit.MINUTES.toMillis(10L);
    private final Date expiry;
    private final Object cacheAccessGuard = new Object();
    private final String key;
    private final AtomicInteger readers = new AtomicInteger(0);
    private final DefaultCacheEntryStatistics statistics;
    private final Object writeSignal = new Object();
    private volatile Exception cacheWriteException;
    private volatile State state;
    private volatile CacheWriteState writeState;
    private volatile long bytesWritten;

    protected AbstractCacheEntry(String cacheKey, Date expiry) {
        this.expiry = expiry != null ? new Date(expiry.getTime()) : null;
        this.key = cacheKey;
        this.state = State.NOT_INITIALIZED;
        this.statistics = new DefaultCacheEntryStatistics(cacheKey);
        this.writeState = CacheWriteState.NOT_STARTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheAccess access(OutputStream outputStream, ContentProvider contentProvider, StreamPumper streamPump) throws IOException {
        Preconditions.checkNotNull((Object)contentProvider, (Object)"contentProvider");
        Preconditions.checkNotNull((Object)outputStream, (Object)"outputStream");
        this.checkNotExpired();
        Object object = this.cacheAccessGuard;
        synchronized (object) {
            this.checkNotExpired();
            OutputStream cacheOutputStream = this.getCacheOutputStream();
            InputStream cacheInputStream = this.getCacheInputStream();
            if (cacheOutputStream == null) {
                this.statistics.onCacheHit();
            }
            return new CacheEntryAccess(cacheInputStream, outputStream, cacheOutputStream, contentProvider, streamPump);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.cacheAccessGuard;
        synchronized (object) {
            this.state = State.INVALIDATED;
        }
        log.debug("invalidating clone cache {} (cache has {} readers)", (Object)this.key, (Object)this.readers.get());
        this.cleanUpCacheFileWhenInvalid();
    }

    public boolean isExpired() {
        return this.expiry != null && System.currentTimeMillis() > this.expiry.getTime();
    }

    public boolean isValid() {
        return this.state != State.INVALIDATED;
    }

    public CacheEntryStatistics getStatistics() {
        return this.statistics;
    }

    public CacheResult stream(OutputStream outputStream, ContentProvider contentProvider, StreamPumper pump) throws IOException {
        return this.access(outputStream, contentProvider, pump).stream();
    }

    protected abstract void doCleanup();

    @Nonnull
    protected abstract InputStream doCreateCacheInputStream() throws IOException;

    @Nonnull
    protected abstract OutputStream doCreateCacheOutputStream() throws IOException;

    private void checkNotExpired() {
        if (this.state != State.INVALIDATED && (this.isExpired() || !this.isValid())) {
            this.invalidate();
        }
        if (this.state == State.INVALIDATED) {
            throw new CacheEntryExpiredException("CacheEntry has been invalidated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpCacheFileWhenInvalid() {
        if (this.state != State.INVALIDATED || this.readers.get() > 0) {
            return;
        }
        Object object = this.cacheAccessGuard;
        synchronized (object) {
            if (this.state != State.INVALIDATED || this.readers.get() > 0) {
                return;
            }
            this.doCleanup();
            this.statistics.setSize(0L);
        }
    }

    private InputStream getCacheInputStream() throws IOException {
        SyncingInputStream inputStream = new SyncingInputStream(this.doCreateCacheInputStream());
        this.readers.incrementAndGet();
        return new BufferedInputStream(inputStream);
    }

    private OutputStream getCacheOutputStream() throws IOException {
        if (this.state != State.NOT_INITIALIZED) {
            return null;
        }
        try {
            OutputStream delegate = this.doCreateCacheOutputStream();
            this.state = State.AVAILABLE;
            return new BufferedOutputStream(new SyncingOutputStream(delegate));
        }
        catch (Throwable t) {
            this.handleWriteError(t);
            Throwables.propagateIfPossible((Throwable)t, IOException.class);
            Throwables.propagateIfPossible((Throwable)t);
            throw new IOException(t);
        }
    }

    private void handleWriteError(Throwable t) {
        this.invalidate();
        if (t instanceof Exception) {
            this.cacheWriteException = (Exception)t;
        }
        this.setWriteState(CacheWriteState.ERROR);
        log.info("Invalidating cache entry {}. An error occurred while writing to the cache {}", (Object)this.key, (Object)t.getLocalizedMessage());
        log.debug("Error details", t);
    }

    private void onReaderFinished() {
        this.readers.decrementAndGet();
        this.cleanUpCacheFileWhenInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWriteState(CacheWriteState state) {
        Object object = this.writeSignal;
        synchronized (object) {
            this.writeState = state;
            this.writeSignal.notifyAll();
        }
    }

    private class SyncingOutputStream
    extends OutputStream {
        private final OutputStream delegate;
        private long lastNotify = 0L;

        private SyncingOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
            ++AbstractCacheEntry.this.bytesWritten;
            this.notifyReaders();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
            AbstractCacheEntry.this.bytesWritten += b.length;
            this.notifyReaders();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
            AbstractCacheEntry.this.bytesWritten += len;
            this.notifyReaders();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
                super.close();
            }
            finally {
                AbstractCacheEntry.this.statistics.setSize(AbstractCacheEntry.this.bytesWritten);
                this.notifyReaders();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyReaders() {
            if (AbstractCacheEntry.this.writeState != CacheWriteState.WRITING || this.lastNotify + 150L < System.currentTimeMillis()) {
                Object object = AbstractCacheEntry.this.writeSignal;
                synchronized (object) {
                    this.lastNotify = System.currentTimeMillis();
                    AbstractCacheEntry.this.writeSignal.notifyAll();
                }
            }
        }
    }

    private class SyncingInputStream
    extends InputStream {
        private final InputStream delegate;
        private final AtomicBoolean complete = new AtomicBoolean(false);
        private long bytesRead;

        private SyncingInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public int read() throws IOException {
            this.maybeWaitForData();
            return this.read(this.delegate.read(), 1);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.maybeWaitForData();
            return this.readByteArr(this.delegate.read(b, off, len));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
                super.close();
            }
            finally {
                if (this.complete.compareAndSet(false, true)) {
                    AbstractCacheEntry.this.onReaderFinished();
                }
            }
        }

        private int readByteArr(int result) {
            return this.read(result, result);
        }

        private int read(int result, int numBytesRead) {
            if (result == -1) {
                if (this.complete.compareAndSet(false, true)) {
                    AbstractCacheEntry.this.onReaderFinished();
                }
            } else {
                this.bytesRead += (long)numBytesRead;
            }
            return result;
        }

        private boolean shouldWaitForData() throws IOException {
            return AbstractCacheEntry.this.writeState == CacheWriteState.WRITING && this.bytesRead == AbstractCacheEntry.this.bytesWritten;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeWaitForData() {
            block8: {
                try {
                    if (!this.shouldWaitForData()) break block8;
                    Object object = AbstractCacheEntry.this.writeSignal;
                    synchronized (object) {
                        long waitStart = System.currentTimeMillis();
                        while (this.shouldWaitForData()) {
                            if (System.currentTimeMillis() - waitStart >= MAX_WAIT_FOR_DATA_MS) {
                                AbstractCacheEntry.this.invalidate();
                                throw new IllegalStateException("Possible deadlock detected while reading from the cache. Aborting and invalidating the cache entry.");
                            }
                            AbstractCacheEntry.this.writeSignal.wait(MAX_WAIT_FOR_DATA_MS);
                        }
                    }
                }
                catch (IOException e) {
                    log.debug("Error while waiting for data", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static enum State {
        NOT_INITIALIZED,
        AVAILABLE,
        INVALIDATED;

    }

    private class CacheEntryAccess
    implements CacheAccess {
        private final OutputStream cacheOutputStream;
        private final InputStream cacheInputStream;
        private final StreamPumper streamPumper;
        private final OutputStream outputStream;
        private final ContentProvider contentProvider;
        private volatile boolean closed;

        private CacheEntryAccess(InputStream cacheInputStream, OutputStream outputStream, OutputStream cacheOutputStream, ContentProvider contentProvider, StreamPumper pump) {
            this.cacheOutputStream = cacheOutputStream;
            this.cacheInputStream = cacheInputStream;
            this.streamPumper = pump;
            this.outputStream = outputStream;
            this.contentProvider = contentProvider;
        }

        @Override
        @Nonnull
        public CacheResult getResult() {
            if (this.cacheOutputStream == null) {
                return CacheResult.HIT;
            }
            if (AbstractCacheEntry.this.writeState == CacheWriteState.ABORTED) {
                return CacheResult.BYPASS;
            }
            return CacheResult.MISS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nonnull
        public CacheResult stream() throws IOException {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"CacheAccess has been closed");
            try {
                if (this.cacheInputStream == null) {
                    throw new CacheEntryExpiredException("The cache entry has been invalidated");
                }
                if (AbstractCacheEntry.this.writeState == CacheWriteState.ABORTED) {
                    this.contentProvider.apply(this.outputStream);
                    CacheResult cacheResult = CacheResult.BYPASS;
                    return cacheResult;
                }
                DefaultStreamPump cacheToClientPump = new DefaultStreamPump(this.cacheInputStream, this.outputStream);
                if (this.cacheOutputStream != null) {
                    this.streamPumper.add(cacheToClientPump);
                    this.streamToCache(this.contentProvider, this.cacheOutputStream);
                }
                this.streamPumper.remove(cacheToClientPump);
                cacheToClientPump.pumpAll();
                if (AbstractCacheEntry.this.cacheWriteException != null) {
                    Throwables.propagateIfPossible((Throwable)AbstractCacheEntry.this.cacheWriteException);
                    Throwables.propagateIfInstanceOf((Throwable)AbstractCacheEntry.this.cacheWriteException, IOException.class);
                }
                CacheResult cacheResult = this.getResult();
                return cacheResult;
            }
            finally {
                this.close();
            }
        }

        @Override
        public void cancel() {
            if (this.cacheOutputStream != null && AbstractCacheEntry.this.writeState == CacheWriteState.NOT_STARTED) {
                AbstractCacheEntry.this.invalidate();
                AbstractCacheEntry.this.setWriteState(CacheWriteState.ABORTED);
            }
            this.close();
        }

        private void close() {
            Closeables.closeQuietly((Closeable)this.cacheOutputStream);
            Closeables.closeQuietly((Closeable)this.cacheInputStream);
            this.closed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void streamToCache(ContentProvider contentProvider, OutputStream cacheOutputStream) {
            try {
                if (AbstractCacheEntry.this.writeState != CacheWriteState.NOT_STARTED) {
                    throw new IllegalStateException("Cannot write to the cache - state is " + AbstractCacheEntry.this.writeState.name());
                }
                AbstractCacheEntry.this.setWriteState(CacheWriteState.WRITING);
                contentProvider.apply(cacheOutputStream);
                AbstractCacheEntry.this.setWriteState(CacheWriteState.COMPLETED);
            }
            catch (Throwable t) {
                AbstractCacheEntry.this.handleWriteError(t);
            }
            finally {
                Closeables.closeQuietly((Closeable)cacheOutputStream);
            }
        }
    }
}

