/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.Assertions;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
abstract class AbstractCopyOnWriteMap<K, V, M extends Map<K, V>>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 4508989182041753878L;
    private volatile M delegate;
    private final transient EntrySet entrySet = new EntrySet();
    private final transient KeySet keySet = new KeySet();
    private final transient Values values = new Values();

    protected <N extends Map<? extends K, ? extends V>> AbstractCopyOnWriteMap(N map) {
        this.delegate = (Map)Assertions.notNull("delegate", this.copy(Assertions.notNull("map", map)));
    }

    abstract <N extends Map<? extends K, ? extends V>> M copy(N var1);

    @Override
    public final synchronized void clear() {
        M map = this.copy();
        map.clear();
        this.set(map);
    }

    @Override
    public final synchronized V remove(Object key) {
        if (!this.delegate.containsKey(key)) {
            return null;
        }
        M map = this.copy();
        Object result = map.remove(key);
        this.set(map);
        return result;
    }

    @Override
    public final synchronized V put(K key, V value) {
        M map = this.copy();
        V result = map.put(key, value);
        this.set(map);
        return result;
    }

    @Override
    public final synchronized void putAll(Map<? extends K, ? extends V> t) {
        M map = this.copy();
        map.putAll(t);
        this.set(map);
    }

    protected synchronized void removeAll(Collection<K> keys) {
        M map = this.copy();
        for (K k : keys) {
            map.remove(k);
        }
        this.set(map);
    }

    protected synchronized M copy() {
        return this.copy((Map)this.delegate);
    }

    protected synchronized void set(M map) {
        this.delegate = map;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public final Set<K> keySet() {
        return this.keySet;
    }

    @Override
    public final Collection<V> values() {
        return this.values;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public final V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public final boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public final int size() {
        return this.delegate.size();
    }

    @Override
    public final boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public final int hashCode() {
        return this.delegate.hashCode();
    }

    protected final M getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class CollectionView<E>
    implements Collection<E> {
        protected CollectionView() {
        }

        abstract Collection<E> getDelegate();

        @Override
        public final boolean contains(Object o) {
            return this.getDelegate().contains(o);
        }

        @Override
        public final boolean containsAll(Collection<?> c) {
            return this.getDelegate().containsAll(c);
        }

        @Override
        public final Iterator<E> iterator() {
            return new UnmodifiableIterator<E>(this.getDelegate().iterator());
        }

        @Override
        public final boolean isEmpty() {
            return this.getDelegate().isEmpty();
        }

        @Override
        public final int size() {
            return this.getDelegate().size();
        }

        @Override
        public final Object[] toArray() {
            return this.getDelegate().toArray();
        }

        @Override
        public final <T> T[] toArray(T[] a) {
            return this.getDelegate().toArray(a);
        }

        @Override
        public int hashCode() {
            return ((Object)this.getDelegate()).hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return ((Object)this.getDelegate()).equals(obj);
        }

        @Override
        public final boolean add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableIterator<T>
    implements Iterator<T> {
        private final Iterator<T> delegate;

        public UnmodifiableIterator(Iterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends CollectionView<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        Collection<Map.Entry<K, V>> getDelegate() {
            return AbstractCopyOnWriteMap.this.delegate.entrySet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            AbstractCopyOnWriteMap abstractCopyOnWriteMap = AbstractCopyOnWriteMap.this;
            synchronized (abstractCopyOnWriteMap) {
                Object map = AbstractCopyOnWriteMap.this.copy();
                map.entrySet().clear();
                AbstractCopyOnWriteMap.this.set(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            AbstractCopyOnWriteMap abstractCopyOnWriteMap = AbstractCopyOnWriteMap.this;
            synchronized (abstractCopyOnWriteMap) {
                if (!this.contains(o)) {
                    return false;
                }
                Object map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.entrySet().remove(o);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            AbstractCopyOnWriteMap abstractCopyOnWriteMap = AbstractCopyOnWriteMap.this;
            synchronized (abstractCopyOnWriteMap) {
                Object map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.entrySet().removeAll(c);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            AbstractCopyOnWriteMap abstractCopyOnWriteMap = AbstractCopyOnWriteMap.this;
            synchronized (abstractCopyOnWriteMap) {
                Object map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.entrySet().retainAll(c);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Values
    extends CollectionView<V>
    implements Collection<V> {
        private Values() {
        }

        @Override
        Collection<V> getDelegate() {
            return AbstractCopyOnWriteMap.this.delegate.values();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            AbstractCopyOnWriteMap abstractCopyOnWriteMap = AbstractCopyOnWriteMap.this;
            synchronized (abstractCopyOnWriteMap) {
                Object map = AbstractCopyOnWriteMap.this.copy();
                map.values().clear();
                AbstractCopyOnWriteMap.this.set(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            AbstractCopyOnWriteMap abstractCopyOnWriteMap = AbstractCopyOnWriteMap.this;
            synchronized (abstractCopyOnWriteMap) {
                if (!this.contains(o)) {
                    return false;
                }
                Object map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.values().remove(o);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            AbstractCopyOnWriteMap abstractCopyOnWriteMap = AbstractCopyOnWriteMap.this;
            synchronized (abstractCopyOnWriteMap) {
                Object map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.values().removeAll(c);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            AbstractCopyOnWriteMap abstractCopyOnWriteMap = AbstractCopyOnWriteMap.this;
            synchronized (abstractCopyOnWriteMap) {
                Object map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.values().retainAll(c);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends CollectionView<K>
    implements Set<K> {
        private KeySet() {
        }

        @Override
        Collection<K> getDelegate() {
            return AbstractCopyOnWriteMap.this.delegate.keySet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            AbstractCopyOnWriteMap abstractCopyOnWriteMap = AbstractCopyOnWriteMap.this;
            synchronized (abstractCopyOnWriteMap) {
                Object map = AbstractCopyOnWriteMap.this.copy();
                map.keySet().clear();
                AbstractCopyOnWriteMap.this.set(map);
            }
        }

        @Override
        public boolean remove(Object o) {
            return AbstractCopyOnWriteMap.this.remove(o) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            AbstractCopyOnWriteMap abstractCopyOnWriteMap = AbstractCopyOnWriteMap.this;
            synchronized (abstractCopyOnWriteMap) {
                Object map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.keySet().removeAll(c);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            AbstractCopyOnWriteMap abstractCopyOnWriteMap = AbstractCopyOnWriteMap.this;
            synchronized (abstractCopyOnWriteMap) {
                Object map = AbstractCopyOnWriteMap.this.copy();
                boolean result = map.keySet().retainAll(c);
                AbstractCopyOnWriteMap.this.set(map);
                return result;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface CopyFunction<M extends Map<?, ?>> {
        public M copy(M var1);
    }
}

