UPM.define('CustomerAgreementDialog', [
    'UpmDialog',
    'UpmAnalytics'
], function (UpmDialog,
             UpmAnalytics) {

    'use strict';

    return UpmDialog.extend({

        template: com.atlassian.upm.application.customerAgreementDialog,

        initialize: function (options) {
            UpmDialog.prototype.initialize.call(this, (options || {}));
        },

        _getData: function() {
            return {
                showRedirectMessage: this.options.showRedirectMessage
            };
        },

        _postShow: function () {
            this.$el.find('a').blur();
            UpmAnalytics.logEvent('manageapps-customer-agreement-show');
        },

        getResult: function () {
            return UpmDialog.prototype.getResult.apply(this)
                .done(function () {
                    UpmAnalytics.logEvent('manageapps-customer-agreement-accept');
                })
                .fail(function () {
                    UpmAnalytics.logEvent('manageapps-customer-agreement-decline');
                });
        }

    });
});
