UPM.define('AuiFlagManager', [
    'underscore',
    'aui/flag'
], function (_, AuiFlag) {


    'use strict';


    var FlagManager = {};


    /**
     * Wrapper for AuiFlag.
     * @param options. {object} Aui flag options
     *  - type {string}: Aui flag type: info, warning, error, success
     *  - body {string}: Content of the flag. Can contain html.
     *  - close {string}: Dismissal behavior of the flag: auto, manual, never
     */
    FlagManager.flag = function (options) {
        var wrappedBody = '<div class="upm-versions-licenses-flag">' + options.body + '</div>';
        AuiFlag(_.extend({}, options, { body: wrappedBody }));
    };

    /**
     * Throws an aui flag after a delay.
     * @param options. {object} Aui flag options
     *  - type {string}: Aui flag type: info, warning, error, success
     *  - body {string}: Content of the flag. Can contain html.
     *  - close {string}: Dismissal behavior of the flag: auto, manual, never
     *  - delay {int}: optional. Millisecond delay before throwing the flag. Defaults to 350ms
     */
    FlagManager.delayedFlag = function (options) {
        var delay = options.delay || 350;
        delete options.delay;
        setTimeout(function () {
            FlagManager.flag(options);
        }, delay);
    };


    return FlagManager;
});