UPM.define('ManageApplicationsEnvironment',
    [],
    function() {

    /**
     * Similar to UpmEnvironment, but defines properties that are only relevant to Manage Applications
     * and not to UPM.
     */
    var ManageApplicationsEnvironment = {

        getAppUpdatesUrl: function(targetPlatformBuildNumber) {
            return AJS.params.appUpdatesResource + '?buildNumber=' + targetPlatformBuildNumber;
        },

        getScheduledBundledUpdatesUrl: function(targetPlatformBuildNumber) {
            return AJS.params.scheduledBundledUpdatesResource +
                '?buildNumber=' + targetPlatformBuildNumber;
        },

        getPlatformBuildNumber: function () {
            return parseInt(AJS.params['platform-build-number']);
        },

        getPlatformApplicationName: function () {
            return AJS.params['platform-application-name'];
        },
        
        isDataCenter: function () {
            return !!AJS.params['manage-applications-data-center'];
        }
    };

    return ManageApplicationsEnvironment;
});
