/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal.impl;

import com.atlassian.upm.impl.DateUtil;
import com.atlassian.upm.license.internal.LicenseDateFormatter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DefaultLicenseDateFormatter
implements LicenseDateFormatter {
    private static final String DEFAULT_DATE_TIME_FORMAT = "d MMM yyyy";
    private static final String DEFAULT_DATE_FORMAT = "d MMM yyyy";

    @Override
    @Deprecated
    public String formatDateTime(DateTime licenseDate) {
        return this.formatDateTime(DateUtil.toZonedDate(licenseDate));
    }

    @Override
    public String formatDateTime(ZonedDateTime licenseDate) {
        return this.formatInternal(licenseDate, "d MMM yyyy");
    }

    @Override
    @Deprecated
    public String formatDate(DateTime licenseDate) {
        return this.formatDate(DateUtil.toZonedDate(licenseDate));
    }

    @Override
    public String formatDate(ZonedDateTime licenseDate) {
        return this.formatInternal(licenseDate, "d MMM yyyy");
    }

    protected String formatInternal(ZonedDateTime licenseDate, String format) {
        Objects.requireNonNull(licenseDate, "licenseDate");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(this.getUserTimeZoneId());
        return formatter.format(licenseDate);
    }

    @Deprecated
    protected DateTimeZone getUserTimeZone() {
        try {
            return DateTimeZone.forID((String)System.getProperty("user.timezone"));
        }
        catch (IllegalArgumentException e) {
            return DateTimeZone.getDefault();
        }
    }

    protected ZoneId getUserTimeZoneId() {
        try {
            return ZoneId.of(System.getProperty("user.timezone"));
        }
        catch (IllegalArgumentException e) {
            return ZoneId.systemDefault();
        }
    }
}

