/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.spring;

import com.atlassian.cache.CacheFactory;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.JiraOnly;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.core.impl.JiraApplicationDescriptor;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.license.internal.HostApplicationLicenseFactory;
import com.atlassian.upm.license.internal.JiraLicenseDateFormatter;
import com.atlassian.upm.license.internal.LicenseManagerProvider;
import com.atlassian.upm.license.internal.host.JiraHostLicenseProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Conditional(value={JiraOnly.class})
@Configuration
public class JiraConfig {
    @Bean
    public DateTimeFormatter dateTimeFormatter() {
        return OsgiServices.importOsgiService(DateTimeFormatter.class);
    }

    @Bean
    public JiraApplicationDescriptor jiraApplicationDescriptor(UpmAppManager upmAppManager, LicenseCountService licenseCountService) {
        return new JiraApplicationDescriptor(upmAppManager, licenseCountService);
    }

    @Bean
    public JiraHostLicenseProvider jiraHostLicenseProvider(JiraLicenseManager jiraLicenseManager, LicenseManagerProvider licenseManagerProvider, LicenseHandler licenseHandler, HostApplicationLicenseFactory hostApplicationLicenseFactory, UpmAppManager appManager, CacheFactory cacheFactory) {
        return new JiraHostLicenseProvider(jiraLicenseManager, licenseManagerProvider, licenseHandler, hostApplicationLicenseFactory, appManager, cacheFactory);
    }

    @Bean
    public JiraLicenseDateFormatter jiraLicenseDateFormatter(DateTimeFormatter dateTimeFormatter) {
        return new JiraLicenseDateFormatter(dateTimeFormatter);
    }

    @Bean
    public JiraLicenseManager jiraLicenseManager() {
        return OsgiServices.importOsgiService(JiraLicenseManager.class);
    }

    @Bean
    public LicenseCountService licenseCountService() {
        return OsgiServices.importOsgiService(LicenseCountService.class);
    }

    @Bean
    public UserManager userManager() {
        return OsgiServices.importOsgiService(UserManager.class);
    }
}

