/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.servlet;

import com.atlassian.upm.application.impl.ApplicationActionResultService;
import com.atlassian.upm.application.impl.ApplicationLicenseReceiptHandler;
import com.atlassian.upm.application.impl.ApplicationUriBuilder;
import com.atlassian.upm.core.actionresult.ActionResultCollection;
import io.atlassian.fugue.Either;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;

public class ApplicationLicenseReceiptServlet
extends HttpServlet {
    private final ApplicationUriBuilder applicationUriBuilder;
    private final ApplicationLicenseReceiptHandler handler;
    private final ApplicationActionResultService resultService;

    public ApplicationLicenseReceiptServlet(ApplicationUriBuilder applicationUriBuilder, ApplicationLicenseReceiptHandler handler, ApplicationActionResultService resultService) {
        this.handler = handler;
        this.applicationUriBuilder = Objects.requireNonNull(applicationUriBuilder, "applicationUriBuilder");
        this.resultService = Objects.requireNonNull(resultService, "resultService");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Either<ApplicationLicenseReceiptHandler.RequestError, ActionResultCollection> handled = this.handler.handle(request);
        if (handled.isLeft()) {
            switch ((ApplicationLicenseReceiptHandler.RequestError)((Object)handled.left().get())) {
                case NOT_AUTHENTICATED: {
                    UriBuilder uri = UriBuilder.fromUri((URI)this.applicationUriBuilder.buildManageAppsUri());
                    uri.queryParam("authentication-error", new Object[]{""});
                    response.sendRedirect(uri.build(new Object[0]).toString());
                    break;
                }
                case BAD_REFERRER: {
                    response.sendError(400);
                }
            }
        } else {
            UriBuilder uri = UriBuilder.fromUri((URI)this.applicationUriBuilder.buildManageAppsUri());
            for (ActionResultCollection results : handled.right()) {
                String resultsId = this.resultService.storeResults(results);
                uri.queryParam("notification-token", new Object[]{resultsId});
                response.sendRedirect(uri.build(new Object[0]).toString());
            }
        }
    }
}

