/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.rest.resources;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.application.api.PluginApplication;
import com.atlassian.upm.application.impl.ApplicationAccessor;
import com.atlassian.upm.application.rest.representations.ApplicationUpdateCollectionRepresentation;
import com.atlassian.upm.application.rest.representations.ApplicationUpdateRepresentation;
import com.atlassian.upm.core.BundledUpdateInfo;
import com.atlassian.upm.core.BundledUpdateInfoStore;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/updates/scheduled")
public class ScheduledBundledUpdatesResource {
    private final ApplicationAccessor applicationAccessor;
    private final ApplicationManager applicationManager;
    private final BundledUpdateInfoStore bundledUpdateInfoStore;
    private final PermissionEnforcer permissionEnforcer;

    public ScheduledBundledUpdatesResource(ApplicationAccessor applicationAccessor, ApplicationManager applicationManager, BundledUpdateInfoStore bundledUpdateInfoStore, PermissionEnforcer permissionEnforcer) {
        this.applicationAccessor = Objects.requireNonNull(applicationAccessor, "applicationAccessor");
        this.applicationManager = Objects.requireNonNull(applicationManager, "applicationManager");
        this.bundledUpdateInfoStore = Objects.requireNonNull(bundledUpdateInfoStore, "bundledUpdateInfoStore");
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
    }

    @POST
    @Consumes(value={"application/vnd.atl.plugins+json"})
    public Response post(@QueryParam(value="buildNumber") int platformBuildNumber, ApplicationUpdateCollectionRepresentation updates) {
        this.permissionEnforcer.enforcePermission(Permission.MANAGE_IN_PROCESS_PLUGIN_INSTALL_FROM_URI);
        ImmutableList.Builder itemsBuilder = ImmutableList.builder();
        for (ApplicationUpdateRepresentation item : updates.getUpdates()) {
            for (Application a : this.applicationManager.getApplication(ApplicationKey.valueOf((String)item.getKey()))) {
                if (!(a instanceof PluginApplication)) continue;
                for (URI uri : Option.option((Object)item.getLinks().get("binary"))) {
                    for (String pluginKey : this.applicationAccessor.getPrimaryPluginKey(a)) {
                        itemsBuilder.add((Object)new BundledUpdateInfo.UpdateItem(pluginKey, a.getName(), item.getUpdateVersion(), uri));
                    }
                }
            }
        }
        ImmutableList updateItems = itemsBuilder.build();
        BundledUpdateInfo updateInfo = new BundledUpdateInfo(platformBuildNumber, (Collection<BundledUpdateInfo.UpdateItem>)updateItems);
        this.bundledUpdateInfoStore.setUpdateInfo(com.atlassian.upm.api.util.Option.some(updateInfo));
        return Response.noContent().build();
    }

    @DELETE
    @Consumes(value={"application/vnd.atl.plugins+json"})
    public Response delete() {
        this.permissionEnforcer.enforcePermission(Permission.MANAGE_IN_PROCESS_PLUGIN_INSTALL_FROM_URI);
        this.bundledUpdateInfoStore.setUpdateInfo(com.atlassian.upm.api.util.Option.none(BundledUpdateInfo.class));
        return Response.noContent().build();
    }
}

