/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.rest.resources;

import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.RawProductLicense;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.validate.LicenseErrorCode;
import com.atlassian.sal.api.validate.MultipleLicensesValidationResult;
import com.atlassian.upm.application.rest.resources.MultipleApplicationLicenseAdapterFactory;
import com.atlassian.upm.application.rest.resources.MultipleApplicationLicenseResponse;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;

public class MultipleApplicationLicenseAdapter {
    private final LicenseHandler licenseHandler;
    private final LocaleResolver localeResolver;

    public MultipleApplicationLicenseAdapter(LicenseHandler licenseHandler, LocaleResolver localeResolver) {
        this.licenseHandler = Objects.requireNonNull(licenseHandler);
        this.localeResolver = Objects.requireNonNull(localeResolver);
    }

    public Response validateAndUpdateMultipleProductLicenses(Collection<MultipleApplicationLicenseAdapterFactory.LicenseUpdate> updates, Operation operation) {
        MultipleApplicationLicenseResponse response = this.validateMultipleProductLicenses(updates);
        if (operation == Operation.ValidateAndUpdate && !response.hasErrors()) {
            try {
                this.licenseHandler.addProductLicenses(updates.stream().map(RawProductLicenseImpl::new).collect(Collectors.toSet()));
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)MultipleApplicationLicenseResponse.generalError(e.getLocalizedMessage())).build();
            }
        }
        return Response.status((Response.Status)(response.hasErrors() ? Response.Status.BAD_REQUEST : Response.Status.OK)).entity((Object)response).build();
    }

    public MultipleApplicationLicenseResponse validateMultipleProductLicenses(Collection<MultipleApplicationLicenseAdapterFactory.LicenseUpdate> updates) {
        Set licenseUpdates = updates.stream().map(RawProductLicenseImpl::new).collect(Collectors.toSet());
        MultipleLicensesValidationResult result = this.licenseHandler.validateMultipleProductLicenses(licenseUpdates, this.localeResolver.getLocale());
        return new MultipleApplicationLicenseResponse(this.collectErrorsAndWarningsByProductKey(result), this.isAllEvaluationLicenses(updates));
    }

    private Map<String, MultipleApplicationLicenseResponse.LicenseResult> collectErrorsAndWarningsByProductKey(MultipleLicensesValidationResult result) {
        return result.getLicenseValidationResults().stream().collect(Collectors.toMap(r -> r.getProductKey().orElse("no-app-key"), r -> new MultipleApplicationLicenseResponse.LicenseResult(r.getErrorMessages().stream().map(e -> new MultipleApplicationLicenseResponse.LicenseError(e.getErrorMessage(), e.getLicenseErrorCode() == LicenseErrorCode.INCOMPATIBLE_HOSTING_TYPE)).collect(Collectors.toList()), r.getWarningMessages().stream().map(e -> new MultipleApplicationLicenseResponse.LicenseWarning(e.getWarningMessage())).collect(Collectors.toList()))));
    }

    private boolean isAllEvaluationLicenses(Collection<MultipleApplicationLicenseAdapterFactory.LicenseUpdate> updates) {
        return updates.stream().filter(u -> u.getLicense().isPresent() && !u.isDelete()).allMatch(u -> this.isLicenseEval(u.getLicense().get()));
    }

    private boolean isLicenseEval(String license) {
        try {
            return this.licenseHandler.decodeLicenseDetails(license).isEvaluationLicense();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class RawProductLicenseImpl
    implements RawProductLicense {
        private final MultipleApplicationLicenseAdapterFactory.LicenseUpdate licenseUpdate;

        public RawProductLicenseImpl(MultipleApplicationLicenseAdapterFactory.LicenseUpdate licenseUpdate) {
            this.licenseUpdate = licenseUpdate;
        }

        @Nonnull
        public Optional<String> getProductKey() {
            return this.licenseUpdate.getProductKey();
        }

        @Nonnull
        public Optional<String> getLicense() {
            return this.licenseUpdate.getLicense();
        }

        public boolean isDeleteLicense() {
            return this.licenseUpdate.isDelete();
        }
    }

    public static enum Operation {
        ValidateOnly,
        ValidateAndUpdate;

    }
}

