/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.rest.resources;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import java.util.Iterator;
import java.util.Objects;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/installed/{applicationKey}/clear-configuration")
public class ApplicationClearConfigResource {
    private final ApplicationManager applicationManager;
    private final PermissionEnforcer permissionEnforcer;

    public ApplicationClearConfigResource(ApplicationManager applicationManager, PermissionEnforcer permissionEnforcer) {
        this.applicationManager = Objects.requireNonNull(applicationManager, "applicationManager");
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer, "permissionEnforcer");
    }

    @DELETE
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response remove(@PathParam(value="applicationKey") String applicationKey) {
        this.permissionEnforcer.enforcePermission(Permission.MANAGE_APPLICATION_CONFIG);
        Iterator iterator = this.applicationManager.getApplication(ApplicationKey.valueOf((String)applicationKey)).iterator();
        if (iterator.hasNext()) {
            Application app = (Application)iterator.next();
            app.clearConfiguration();
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

