/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.marketplace;

import io.atlassian.fugue.Option;
import java.util.Collections;

public class MarketplaceResult<T> {
    public final Option<T> value;
    public final boolean mpacDisabled;
    public final boolean mpacUnreachable;

    private MarketplaceResult(Option<T> value, boolean mpacDisabled, boolean mpacUnreachable) {
        this.value = value;
        this.mpacDisabled = mpacDisabled;
        this.mpacUnreachable = mpacUnreachable;
    }

    static <T> MarketplaceResult<T> success(T value) {
        return new MarketplaceResult<T>(Option.some(value), false, false);
    }

    static <T> MarketplaceResult<T> disabled() {
        return new MarketplaceResult<T>(Option.none(), true, false);
    }

    static <T> MarketplaceResult<T> unreachable() {
        return new MarketplaceResult<T>(Option.none(), false, true);
    }

    public static <T> Iterable<T> listFromResult(MarketplaceResult<Iterable<T>> result) {
        return (Iterable)result.value.getOrElse(Collections.emptyList());
    }

    public String toString() {
        if (this.mpacDisabled) {
            return "MarketplaceResult(disabled)";
        }
        if (this.mpacUnreachable) {
            return "MarketplaceResult(unreachable)";
        }
        return "MarketplaceResult(" + this.value.getOrElse(null) + ")";
    }

    public int hashCode() {
        return this.value.hashCode() + (this.mpacDisabled ? 1 : 0) + (this.mpacUnreachable ? 2 : 0);
    }

    public boolean equals(Object other) {
        if (other instanceof MarketplaceResult) {
            MarketplaceResult o = (MarketplaceResult)other;
            return o.mpacDisabled == this.mpacDisabled && o.mpacUnreachable == this.mpacUnreachable && o.value.equals(this.value);
        }
        return false;
    }
}

