/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.impl;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.PlatformApplication;
import com.atlassian.marketplace.client.model.ImageInfo;
import com.atlassian.marketplace.client.model.PaymentModel;
import com.atlassian.marketplace.client.model.Product;
import com.atlassian.marketplace.client.model.ProductVersion;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.atlassian.upm.UpmFugueConverters;
import com.atlassian.upm.application.impl.ApplicationAccessor;
import com.atlassian.upm.application.impl.ApplicationLicenses;
import com.atlassian.upm.application.impl.ApplicationUriBuilder;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.representations.BaseLinkBuilder;
import com.atlassian.upm.core.rest.representations.LinksMapBuilder;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.util.Objects;

public class ApplicationLinkBuilder
extends BaseLinkBuilder {
    public static final String DOWNLOADS_REL = "downloads";
    private final ApplicationUriBuilder uriBuilder;
    private final ApplicationAccessor applicationAccessor;

    public ApplicationLinkBuilder(ApplicationUriBuilder uriBuilder, PermissionEnforcer permissionEnforcer, ApplicationAccessor applicationAccessor) {
        super(permissionEnforcer);
        this.uriBuilder = Objects.requireNonNull(uriBuilder, "uriBuilder");
        this.applicationAccessor = Objects.requireNonNull(applicationAccessor, "applicationAccessor");
    }

    public LinksMapBuilder buildLinksForInstalledApplication(Application app, Option<Product> mpacProduct) {
        LinksMapBuilder builder = this.builder();
        SingleProductLicenseDetailsView license = (SingleProductLicenseDetailsView)app.getLicense().getOrNull();
        int userCount = app.getAccess().getActiveUserCount();
        builder.put("self", this.uriBuilder.buildApplicationUri(app.getKey()));
        builder.put("wac-update", this.uriBuilder.buildWacApplicationUpdateUri(app.getKey()));
        builder.putIfPermitted(Permission.MANAGE_APPLICATION_CONFIG, "clear-configuration", this.uriBuilder.buildClearConfigurationUri(app.getKey()));
        builder.putIfPermitted(Permission.MANAGE_APPLICATION_LICENSES, "license", this.uriBuilder.buildApplicationLicenseUri(app.getKey()));
        builder.putIfPermitted(Permission.MANAGE_APPLICATION_LICENSES, "eval-license-callback", this.uriBuilder.buildApplicationEvalLicenseReceiptUri(app.getKey()));
        for (URI configure : app.getConfigurationURI()) {
            builder.put("configure", configure);
        }
        for (URI postInstall : this.uriBuilder.buildPostInstallUri(app)) {
            builder.put("post-install", postInstall);
        }
        for (URI postUpdate : this.uriBuilder.buildPostUpdateUri(app)) {
            builder.put("post-update", postUpdate);
        }
        if (ApplicationLicenses.isApplicationTryable(app, this.applicationAccessor)) {
            builder.put("try", this.uriBuilder.buildMacCreateAppEvalLicenseUri());
        }
        if (ApplicationLicenses.isApplicationBuyable(app, this.applicationAccessor)) {
            builder.put("buy", this.uriBuilder.buildPurchaseSoftwareUri(app.getKey(), userCount));
        }
        if (ApplicationLicenses.isApplicationUpgradable(app, this.applicationAccessor, userCount)) {
            for (String sen : Option.option((Object)license.getSupportEntitlementNumber())) {
                builder.put("upgrade", this.uriBuilder.buildUpgradeSoftwareUri(sen));
            }
        }
        if (ApplicationLicenses.isApplicationRenewable(app, this.applicationAccessor, app.getAccess().getActiveUserCount())) {
            for (String sen : Option.option((Object)license.getSupportEntitlementNumber())) {
                builder.put("renew", this.uriBuilder.buildRenewSoftwareUri(sen));
            }
        }
        builder.putIfPermittedAndConditioned(Permission.MANAGE_PLUGIN_UNINSTALL, !(app instanceof PlatformApplication), "delete", this.uriBuilder.buildUpmBulkUninstallUri());
        for (Product p : mpacProduct) {
            builder.put(DOWNLOADS_REL, UpmFugueConverters.toUpmOption(p.getDownloadsPageUri()));
        }
        return builder;
    }

    public LinksMapBuilder buildLinksForOrphanedApplicationLicense(ApplicationKey key) {
        return this.builder().put("wac-update", this.uriBuilder.buildWacApplicationUpdateUri(key));
    }

    public LinksMapBuilder buildLinksForApplicationUpdate(ProductVersion mpacVersion) {
        LinksMapBuilder builder = this.builder();
        builder.put("binary", UpmFugueConverters.toUpmOption(mpacVersion.getArtifactUri()));
        builder.put("release-notes", UpmFugueConverters.toUpmOption(mpacVersion.getReleaseNotesUri()));
        return builder;
    }

    public LinksMapBuilder buildLinksForAvailableApplication(Product mpacApplication) {
        LinksMapBuilder builder = this.builder();
        for (ImageInfo titleLogo : mpacApplication.getTitleLogo()) {
            builder.put("titleLogo", titleLogo.getImageUri());
            for (URI highRes : titleLogo.getImageUri(ImageInfo.Size.DEFAULT_SIZE, ImageInfo.Resolution.HIGH_RESOLUTION)) {
                builder.put("titleLogoHighRes", highRes);
            }
        }
        for (ProductVersion v : mpacApplication.getVersion()) {
            for (URI learnMore : v.getLearnMoreUri()) {
                builder.put("learn-more", learnMore);
            }
            for (URI binary : v.getArtifactUri()) {
                builder.put("binary", binary);
            }
            if (v.getPaymentModel() != PaymentModel.PAID_VIA_ATLASSIAN) continue;
            builder.put("try", this.uriBuilder.buildMacCreateAppEvalLicenseUri());
        }
        return builder;
    }

    public LinksMapBuilder buildLinksForManageApplicationsPage() {
        LinksMapBuilder builder = this.builder();
        builder.put("upmUriAtlassianIdLogin", this.uriBuilder.buildAtlassianIdLoginUri()).put("upmUriToken", this.uriBuilder.buildPluginCollectionUri()).put("upmUriAnalytics", this.uriBuilder.buildAnalyticsUri()).put("applicationsRest", this.uriBuilder.buildApplicationRestRoot()).put("availableApps", this.uriBuilder.buildAvailableAppsUri()).put("appUpdatesResource", this.uriBuilder.buildAppUpdatesUri()).put("scheduledBundledUpdatesResource", this.uriBuilder.buildScheduledBundledUpdatesUri()).putIfPermitted(Permission.MANAGE_IN_PROCESS_PLUGIN_INSTALL_FROM_FILE, "upmUriInstallFile", this.uriBuilder.buildPluginCollectionUri()).putIfPermitted(Permission.MANAGE_IN_PROCESS_PLUGIN_INSTALL_FROM_URI, "upmUriInstallUri", this.uriBuilder.buildPluginCollectionUri()).put("uninstall", this.uriBuilder.buildUpmBulkUninstallUri()).put("upm-settings", this.uriBuilder.buildUpmGlobalSettingsUri()).put("mpacBaseUrl", Sys.getMpacBaseUrl());
        return builder;
    }
}

