/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.impl;

import com.atlassian.application.api.Application;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.application.impl.ApplicationAccessor;
import com.atlassian.upm.impl.DateUtil;
import com.atlassian.upm.license.LicensedAttributes;
import io.atlassian.fugue.Option;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;

public abstract class ApplicationLicenses {
    public static boolean isApplicationTryable(Application app, ApplicationAccessor applicationAccessor) {
        return LicensedAttributes.isProductTryable(ApplicationLicenses.from(app, applicationAccessor));
    }

    public static boolean isApplicationBuyable(Application app, ApplicationAccessor applicationAccessor) {
        return LicensedAttributes.isProductBuyable(ApplicationLicenses.from(app, applicationAccessor));
    }

    public static boolean isApplicationRenewable(Application app, ApplicationAccessor applicationAccessor, int currentRoleCount) {
        return LicensedAttributes.isProductRenewable(ApplicationLicenses.from(app, applicationAccessor), com.atlassian.upm.api.util.Option.some(currentRoleCount));
    }

    public static boolean isApplicationUpgradable(Application app, ApplicationAccessor applicationAccessor, int currentRoleCount) {
        return LicensedAttributes.isProductUpgradable(ApplicationLicenses.from(app, applicationAccessor), com.atlassian.upm.api.util.Option.some(currentRoleCount));
    }

    private static com.atlassian.upm.api.util.Option<LicensedAttributes.LicenseAttributes> from(Application app, ApplicationAccessor applicationAccessor) {
        Iterator iterator = app.getLicense().iterator();
        if (iterator.hasNext()) {
            SingleProductLicenseDetailsView license = (SingleProductLicenseDetailsView)iterator.next();
            return com.atlassian.upm.api.util.Option.some(LicensedAttributes.LicenseAttributes.builder().active(true).evaluation(license.isEvaluationLicense()).expiryDate(Optional.of(DateUtil.dateToZonedDateTime(license.getLicenseExpiryDate()))).maintenanceExpiryDate(Optional.of(DateUtil.dateToZonedDateTime(license.getMaintenanceExpiryDate()))).licenseError(ApplicationLicenses.toErrorName(app, applicationAccessor)).edition(ApplicationLicenses.toEdition(license.getNumberOfUsers())).licenseType(license.getLicenseTypeName()).isDataCenter(license.isDataCenter()).build());
        }
        return com.atlassian.upm.api.util.Option.none();
    }

    private static com.atlassian.upm.api.util.Option<Integer> toEdition(int numberOfUsers) {
        return numberOfUsers == -1 ? com.atlassian.upm.api.util.Option.none() : com.atlassian.upm.api.util.Option.some(numberOfUsers);
    }

    public static com.atlassian.upm.api.util.Option<Boolean> isExpired(SingleProductLicenseDetailsView license) {
        Iterator iterator;
        if (!license.isPerpetualLicense() && (iterator = Option.option((Object)license.getLicenseExpiryDate()).iterator()).hasNext()) {
            Date expiryDate = (Date)iterator.next();
            return com.atlassian.upm.api.util.Option.some(DateUtil.dateToZonedDateTime(expiryDate).isBefore(ZonedDateTime.now()));
        }
        return com.atlassian.upm.api.util.Option.none();
    }

    public static com.atlassian.upm.api.util.Option<Boolean> isMaintenanceExpired(SingleProductLicenseDetailsView license) {
        Iterator iterator;
        if (license.isPerpetualLicense() && (iterator = Option.option((Object)license.getMaintenanceExpiryDate()).iterator()).hasNext()) {
            Date expiryDate = (Date)iterator.next();
            return com.atlassian.upm.api.util.Option.some(DateUtil.dateToZonedDateTime(expiryDate).isBefore(ZonedDateTime.now()));
        }
        return com.atlassian.upm.api.util.Option.none();
    }

    public static com.atlassian.upm.api.util.Option<LicenseError> getApplicationError(Application app, ApplicationAccessor applicationAccessor) {
        if (app.getAccess().getActiveUserCount() > (Integer)app.getAccess().getMaximumUserCount().getOrElse((Object)Integer.MAX_VALUE)) {
            return com.atlassian.upm.api.util.Option.some(LicenseError.ROLE_EXCEEDED);
        }
        for (SingleProductLicenseDetailsView license : app.getLicense()) {
            if (!license.isPerpetualLicense() && ApplicationLicenses.isExpired(license).getOrElse(false).booleanValue()) {
                return com.atlassian.upm.api.util.Option.some(LicenseError.EXPIRED);
            }
            for (Date maintenanceExpiryDate : Option.option((Object)license.getMaintenanceExpiryDate())) {
                if (!applicationAccessor.getBuildZonedDate(app).isAfter(DateUtil.dateToZonedDateTime(maintenanceExpiryDate))) continue;
                return com.atlassian.upm.api.util.Option.some(LicenseError.VERSION_MISMATCH);
            }
        }
        return com.atlassian.upm.api.util.Option.none();
    }

    private static com.atlassian.upm.api.util.Option<String> toErrorName(Application app, ApplicationAccessor applicationAccessor) {
        return ApplicationLicenses.getApplicationError(app, applicationAccessor).map(Enum::name);
    }
}

