/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.api.license.event;

import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.license.event.PluginLicenseChangeEvent;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.joda.time.DateTime;

public final class PluginLicenseMaintenancePeriodExpiredEvent
extends PluginLicenseChangeEvent {
    private final DateTime expiryDate;
    private final ZonedDateTime expiryZonedDate;

    @Deprecated
    public PluginLicenseMaintenancePeriodExpiredEvent(PluginLicense license, DateTime expiryDate) {
        super(license);
        this.expiryDate = Objects.requireNonNull(expiryDate, "expiryDate");
        this.expiryZonedDate = expiryDate.toGregorianCalendar().toZonedDateTime();
    }

    public PluginLicenseMaintenancePeriodExpiredEvent(PluginLicense license, ZonedDateTime expiryZonedDate) {
        super(license);
        this.expiryZonedDate = Objects.requireNonNull(expiryZonedDate, "expiryDate");
        this.expiryDate = new DateTime(expiryZonedDate.toInstant().toEpochMilli());
    }

    public String toString() {
        return "Plugin License Maintenance Period Expired: " + this.getPluginKey() + ", Date of Expiry: " + this.expiryDate;
    }

    @Deprecated
    public DateTime getExpiryDate() {
        return this.expiryDate;
    }

    public ZonedDateTime getExpiryZonedDate() {
        return this.expiryZonedDate;
    }
}

