/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.api.license.event;

import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.license.event.PluginLicenseChangeEvent;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTime;

public final class PluginLicenseExpiredEvent
extends PluginLicenseChangeEvent {
    private final ZonedDateTime expiryDate;

    @Deprecated
    public PluginLicenseExpiredEvent(PluginLicense license, DateTime expiryDate) {
        super(license);
        this.expiryDate = Objects.requireNonNull(expiryDate.toGregorianCalendar().toZonedDateTime(), "expiryDate");
    }

    public PluginLicenseExpiredEvent(PluginLicense license, ZonedDateTime expiryDate) {
        super(license);
        this.expiryDate = Objects.requireNonNull(expiryDate, "expiryDate");
    }

    public String toString() {
        return "Plugin License Expired: " + this.getPluginKey() + ", Date of Expiry: " + this.expiryDate;
    }

    @Deprecated
    public DateTime getExpiryDate() {
        return Optional.ofNullable(this.expiryDate).map(expiryDate -> new DateTime(expiryDate.toInstant().toEpochMilli())).orElse(null);
    }

    public ZonedDateTime getExpiryZonedDate() {
        return this.expiryDate;
    }
}

