package com.atlassian.upgrade.spi;

import com.atlassian.annotations.PublicSpi;

import javax.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;

/**
 * SPI for a plugin or the host application to implement in order
 * to be able to participate in legacy AO and SAL upgrades.
 *
 * @since v1.0
 */
@PublicSpi
public interface LegacyUpgradeTaskFactory extends UpgradeTaskFactory {
    /**
     * Get the minimum SAL build number for a plugins data that can be upgraded from.
     *
     * @return the minimum SAL build number for this {@link LegacyUpgradeTaskFactory}
     * @see UpgradeTaskFactory#getMinimumBuildNumber()
     */
    default int getMinimumSalBuildNumber() {
        return 0;
    }

    /**
     * Get the minimum AO build number for a plugins data that can be upgraded from.
     *
     * @return the AO minimum build number for this {@link LegacyUpgradeTaskFactory}
     * @see UpgradeTaskFactory#getMinimumBuildNumber()
     */
    default int getMinimumAoBuildNumber() {
        return 0;
    }

    /**
     * Get all of the SAL upgrade tasks for this given plugin/host app.
     *
     * @return SAL upgrade tasks for this plugin/host app.
     */
    @Nonnull
    default Collection<LegacyUpgradeTask> getAllSalUpgradeTasks() {
        return Collections.emptyList();
    }

    /**
     * Get all of the AO upgrade tasks for this given plugin/host app.
     *
     * @return AO upgrade tasks for this plugin/host app.
     */
    @Nonnull
    default Collection<LegacyUpgradeTask> getAllAoUpgradeTasks() {
        return Collections.emptyList();
    }
}
