package com.atlassian.upgrade.api;

import com.atlassian.annotations.PublicApi;

/**
 * Public API entry to Upgrade Task Framework with operations that plugins or host app may wish to do.
 * In particular, to query the current version of the DB for a given {@link com.atlassian.upgrade.spi.UpgradeTaskFactory}.
 *
 * @since v1.0
 */
@PublicApi
public interface UpgradeTaskService {
    /**
     * Get current version of the host's DB.
     */
    int getDatabaseBuildNumberForHost();

    /**
     * Get current DB version for a plugin.
     */
    int getDatabaseBuildNumberForPlugin(String pluginKey);

    /**
     * Get current DB version for the current plugin (or host platform).
     * <p>
     * Same as {@link #getDatabaseBuildNumberForPlugin(String)} where pluginKey is the caller's pluginKey.
     * Also works for host, returning in that case the same result as {@link #getDatabaseBuildNumberForHost()}
     */
    int getDatabaseBuildNumber();
}