/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.synchrony.proxy.web;

import com.atlassian.synchrony.proxy.util.SynchronyProxyPropertiesHelper;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.ForwardedHeaderFilter;

@Component(value="forwardedHeaderFilter")
public class ConfigurableForwardedHeaderFilter
implements Filter {
    private final ForwardedHeaderFilter forwardedHeaderFilter;
    private boolean useForwardedHeaders;

    public ConfigurableForwardedHeaderFilter(ForwardedHeaderFilter forwardedHeaderFilter) {
        this.forwardedHeaderFilter = forwardedHeaderFilter;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            Properties initParams = SynchronyProxyPropertiesHelper.load((ServletContext)filterConfig.getServletContext());
            this.useForwardedHeaders = Boolean.parseBoolean(initParams.getProperty("useForwardedHeaders", "false"));
        }
        catch (Exception e) {
            throw new ServletException("Error loading ForwardedHeader configuration", (Throwable)e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.useForwardedHeaders) {
            chain.doFilter(request, response);
        } else {
            this.forwardedHeaderFilter.doFilter(request, response, chain);
        }
    }

    void setUseForwardedHeaders(boolean useForwardedHeaders) {
        this.useForwardedHeaders = useForwardedHeaders;
    }
}

