/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.web.conditions;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class HasDatabaseOfTypeCondition
implements Condition {
    static final String TYPE = "type".intern();
    private final ApplicationPropertiesService applicationPropertiesService;
    private Collection<String> types = Lists.newArrayList();

    public HasDatabaseOfTypeCondition(ApplicationPropertiesService applicationPropertiesService) {
        this.applicationPropertiesService = applicationPropertiesService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        String types = params.get(TYPE);
        if (types == null) {
            throw new PluginParseException("A database 'type' must be specified");
        }
        this.types.clear();
        this.types.addAll(Collections2.transform(Arrays.asList(types.split(",")), (Function)new Function<String, String>(){

            public String apply(String input) {
                return "jdbc:" + input.toLowerCase();
            }
        }));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        final String jdbcUrl = this.applicationPropertiesService.getJdbcUrl().toLowerCase();
        return Iterables.any(this.types, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return jdbcUrl.startsWith(input);
            }
        });
    }
}

