/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class RequestUtils {
    private RequestUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static HttpServletResponse unwrap(HttpServletResponse resp) {
        while (resp instanceof ServletResponseWrapper) {
            resp = (HttpServletResponse)((ServletResponseWrapper)resp).getResponse();
        }
        return resp;
    }

    public static String getRemoteHost(HttpServletRequest request) {
        String forwardedFor = request.getHeader("X-Forwarded-For");
        if (StringUtils.isNotEmpty((String)forwardedFor)) {
            String[] forwardedHostsChain;
            for (String hostname : forwardedHostsChain = forwardedFor.split(",")) {
                if (!StringUtils.isNotBlank((String)hostname)) continue;
                return hostname.trim();
            }
        }
        return request.getRemoteHost();
    }

    public static boolean isUserAgentBrowser(HttpServletRequest request) {
        String userAgent = StringUtils.lowerCase((String)request.getHeader("user-agent"));
        return userAgent != null && (userAgent.contains("mozilla") || userAgent.contains("opera"));
    }

    @Nullable
    public static String getParamValue(String paramName, Map<String, String[]> requestParams) {
        String[] vals = requestParams.get(paramName);
        if (vals == null || vals.length == 0) {
            return null;
        }
        String val = vals[0];
        return StringUtils.isBlank((String)val) ? null : val.trim();
    }
}

