/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MarkupUtils {
    public static final Pattern LINKS = Pattern.compile("[\\w]+://[^\\s]+|\\[[^]]+]\\(.*?\\)");

    private MarkupUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static Multimap<String, MatchResult> findMatches(CharSequence input, Pattern includePattern, Pattern excludePattern) {
        ArrayListMultimap matches = ArrayListMultimap.create();
        Matcher matcher = includePattern.matcher(input);
        Matcher excluder = excludePattern != null ? excludePattern.matcher(input) : null;
        boolean hasMatch = matcher.find();
        if (hasMatch) {
            boolean hasExclusion;
            boolean bl = hasExclusion = excluder != null && excluder.find();
            while (hasMatch) {
                if (hasExclusion) {
                    if (matcher.start() >= excluder.end()) {
                        hasExclusion = excluder.find();
                        continue;
                    }
                    if (matcher.end() > excluder.start()) {
                        hasMatch = matcher.find();
                        continue;
                    }
                }
                matches.put((Object)matcher.group().toLowerCase(), (Object)matcher.toMatchResult());
                hasMatch = matcher.find();
            }
        }
        return matches;
    }
}

