/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class FileUtils {
    private FileUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nonnull
    public static File construct(@Nonnull File base, String ... segments) {
        return segments.length == 0 ? base : new File(base, FileUtils.join(segments));
    }

    @Nonnull
    public static File createTempDir(@Nonnull String prefix, @Nullable String suffix, @Nullable File directory) throws IOException {
        File temporary = File.createTempFile(prefix, suffix, directory);
        if (temporary.delete() && temporary.mkdir()) {
            return temporary;
        }
        throw new IOException("Could not create directory: " + temporary);
    }

    @Nonnull
    public static String join(String ... segments) {
        return StringUtils.join((Object[])segments, (String)File.separator);
    }

    public static void mkdir(@Nonnull File directory) {
        Preconditions.checkNotNull((Object)directory, (Object)"directory");
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalStateException(directory.getAbsolutePath() + " already exists and is not a directory");
            }
        } else if (!directory.mkdirs()) {
            throw new IllegalStateException("Could not create " + directory.getAbsolutePath());
        }
    }

    @Nonnull
    public static File mkdir(@Nonnull String path) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)path, (Object)"path")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A path for the created directory is required");
        File dir = new File(path);
        FileUtils.mkdir(dir);
        return dir;
    }

    @Nonnull
    public static File mkdir(@Nullable File parent, @Nonnull String child) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)child, (Object)"child")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A path for the created directory is required");
        File dir = new File(parent, child);
        FileUtils.mkdir(dir);
        return dir;
    }
}

